# Elastic Maps Server

From [Elastic Maps Server](https://www.elastic.co/guide/en/kibana/8.16/maps-connect-to-ems.html#elastic-maps-server) documentation:

> Elastic Maps Server is a self-managed version of Elastic Maps Service offered as a Docker image that provides both the EMS basemaps and EMS boundaries. The image is bundled with basemaps up to zoom level 8. After connecting it to your Elasticsearch cluster for license validation, you have the option to download and configure a more detailed basemaps database.

## Installation instructions

The container can run just publishing the `8080` port without further settings but it won't offer any maps or assets until valid details to connect to an Elasticsearch instance with the appropriate license level are set up using a configuration file or environment variables. Check the [documentation](https://www.elastic.co/guide/en/kibana/8.16/maps-connect-to-ems.html#elastic-maps-server) for all configuration options available. 

## Resource requirements

* EMS Server is a very light application that can run with very few resources from a container with just 100 megabytes or memory and a single CPU.
* The image comes with a basemap up to zoom 8. A full planet download (zoom 14) takes around 74 gigabytes and needs to be mounted into the container.
* It is recommended to mount a separate volume for the application logs.

## Where to file issues

Please reach out to the [Kibana Github repository](https://github.com/elastic/kibana/issues) for any issues with the product.

## Where to get help

If you have any other question, you can use https://discuss.elastic.co, or contact Elastic Support.
