/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.input;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.watcher.watch.Payload;

public interface Input
extends ToXContentObject {
    public String type();

    public static interface Builder<I extends Input> {
        public I build();
    }

    public static abstract class Result
    implements ToXContentObject {
        private static final ParseField STATUS = new ParseField("status", new String[0]);
        private static final ParseField TYPE = new ParseField("type", new String[0]);
        private static final ParseField PAYLOAD = new ParseField("payload", new String[0]);
        protected final String type;
        protected final Status status;
        private final Payload payload;
        @Nullable
        private final Exception exception;

        protected Result(String type, Payload payload) {
            this.status = Status.SUCCESS;
            this.type = type;
            this.payload = payload;
            this.exception = null;
        }

        protected Result(String type, Exception e) {
            this.status = Status.FAILURE;
            this.type = type;
            this.payload = Payload.EMPTY;
            this.exception = e;
        }

        public String type() {
            return this.type;
        }

        public Status status() {
            return this.status;
        }

        public Payload payload() {
            return this.payload;
        }

        public Exception getException() {
            assert (this.status == Status.FAILURE);
            return this.exception;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(TYPE.getPreferredName(), this.type);
            builder.field(STATUS.getPreferredName(), this.status.name().toLowerCase(Locale.ROOT));
            switch (this.status.ordinal()) {
                case 0: {
                    assert (this.payload != null);
                    builder.field(PAYLOAD.getPreferredName(), (ToXContent)this.payload, params);
                    break;
                }
                case 1: {
                    assert (this.exception != null);
                    ElasticsearchException.generateFailureXContent((XContentBuilder)builder, (ToXContent.Params)params, (Exception)this.exception, (boolean)true);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            this.typeXContent(builder, params);
            return builder.endObject();
        }

        protected abstract XContentBuilder typeXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;

        public static enum Status {
            SUCCESS,
            FAILURE;

        }
    }
}

