/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.permission;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.automaton.Automaton;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptorsIntersection;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.core.security.authz.permission.ApplicationPermission;
import org.elasticsearch.xpack.core.security.authz.permission.ClusterPermission;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissionsCache;
import org.elasticsearch.xpack.core.security.authz.permission.IndicesPermission;
import org.elasticsearch.xpack.core.security.authz.permission.RemoteClusterPermissions;
import org.elasticsearch.xpack.core.security.authz.permission.RemoteIndicesPermission;
import org.elasticsearch.xpack.core.security.authz.permission.ResourcePrivilegesMap;
import org.elasticsearch.xpack.core.security.authz.permission.Role;
import org.elasticsearch.xpack.core.security.authz.permission.RunAsPermission;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilegeDescriptor;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilege;
import org.elasticsearch.xpack.core.security.support.Automatons;

public final class LimitedRole
implements Role {
    private static final Logger logger = LogManager.getLogger(LimitedRole.class);
    private final Role baseRole;
    private final Role limitedByRole;

    public LimitedRole(Role baseRole, Role limitedByRole) {
        this.baseRole = Objects.requireNonNull(baseRole);
        this.limitedByRole = Objects.requireNonNull(limitedByRole, "limited by role is required to create limited role");
        assert (!limitedByRole.hasWorkflowsRestriction()) : "limited-by role must not have workflows restriction";
    }

    @Override
    public String[] names() {
        return this.limitedByRole.names();
    }

    @Override
    public ClusterPermission cluster() {
        throw new UnsupportedOperationException("cannot retrieve cluster permission on limited role");
    }

    @Override
    public IndicesPermission indices() {
        throw new UnsupportedOperationException("cannot retrieve indices permission on limited role");
    }

    @Override
    public RemoteIndicesPermission remoteIndices() {
        throw new UnsupportedOperationException("cannot retrieve remote indices permission on limited role");
    }

    @Override
    public RemoteClusterPermissions remoteCluster() {
        throw new UnsupportedOperationException("cannot retrieve remote cluster permission on limited role");
    }

    @Override
    public boolean hasWorkflowsRestriction() {
        return this.baseRole.hasWorkflowsRestriction() || this.limitedByRole.hasWorkflowsRestriction();
    }

    @Override
    public Role forWorkflow(String workflow) {
        Role baseRestricted = this.baseRole.forWorkflow(workflow);
        if (baseRestricted == EMPTY_RESTRICTED_BY_WORKFLOW) {
            return EMPTY_RESTRICTED_BY_WORKFLOW;
        }
        Role limitedByRestricted = this.limitedByRole.forWorkflow(workflow);
        if (limitedByRestricted == EMPTY_RESTRICTED_BY_WORKFLOW) {
            return EMPTY_RESTRICTED_BY_WORKFLOW;
        }
        if (baseRestricted == this.baseRole && limitedByRestricted == this.limitedByRole) {
            return this;
        }
        return baseRestricted.limitedBy(limitedByRestricted);
    }

    @Override
    public ApplicationPermission application() {
        throw new UnsupportedOperationException("cannot retrieve application permission on limited role");
    }

    @Override
    public RunAsPermission runAs() {
        throw new UnsupportedOperationException("cannot retrieve run_as permission on limited role");
    }

    @Override
    public boolean hasFieldOrDocumentLevelSecurity() {
        return this.baseRole.hasFieldOrDocumentLevelSecurity() || this.limitedByRole.hasFieldOrDocumentLevelSecurity();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LimitedRole that = (LimitedRole)o;
        return this.baseRole.equals(that.baseRole) && this.limitedByRole.equals(that.limitedByRole);
    }

    public int hashCode() {
        return Objects.hash(this.baseRole, this.limitedByRole);
    }

    @Override
    public IndicesAccessControl authorize(String action, Set<String> requestedIndicesOrAliases, ProjectMetadata metadata, FieldPermissionsCache fieldPermissionsCache) {
        IndicesAccessControl indicesAccessControl = this.baseRole.authorize(action, requestedIndicesOrAliases, metadata, fieldPermissionsCache);
        IndicesAccessControl limitedByIndicesAccessControl = this.limitedByRole.authorize(action, requestedIndicesOrAliases, metadata, fieldPermissionsCache);
        return indicesAccessControl.limitIndicesAccessControl(limitedByIndicesAccessControl);
    }

    @Override
    public RoleDescriptorsIntersection getRoleDescriptorsIntersectionForRemoteCluster(String remoteClusterAlias, TransportVersion remoteClusterVersion) {
        RoleDescriptorsIntersection baseIntersection = this.baseRole.getRoleDescriptorsIntersectionForRemoteCluster(remoteClusterAlias, remoteClusterVersion);
        if (baseIntersection.roleDescriptorsList().isEmpty()) {
            logger.trace(() -> "Base role [" + Strings.arrayToCommaDelimitedString((Object[])this.baseRole.names()) + "] does not define any role descriptors for remote cluster alias [" + remoteClusterAlias + "]");
            return RoleDescriptorsIntersection.EMPTY;
        }
        RoleDescriptorsIntersection limitedByIntersection = this.limitedByRole.getRoleDescriptorsIntersectionForRemoteCluster(remoteClusterAlias, remoteClusterVersion);
        if (limitedByIntersection.roleDescriptorsList().isEmpty()) {
            logger.trace(() -> "Limited-by role [" + Strings.arrayToCommaDelimitedString((Object[])this.limitedByRole.names()) + "] does not define any role descriptors for remote cluster alias [" + remoteClusterAlias + "]");
            return RoleDescriptorsIntersection.EMPTY;
        }
        ArrayList<Set<RoleDescriptor>> mergedIntersection = new ArrayList<Set<RoleDescriptor>>(baseIntersection.roleDescriptorsList().size() + limitedByIntersection.roleDescriptorsList().size());
        mergedIntersection.addAll(baseIntersection.roleDescriptorsList());
        mergedIntersection.addAll(limitedByIntersection.roleDescriptorsList());
        return new RoleDescriptorsIntersection(Collections.unmodifiableList(mergedIntersection));
    }

    @Override
    public IndicesPermission.IsResourceAuthorizedPredicate allowedIndicesMatcher(String action) {
        return this.baseRole.allowedIndicesMatcher(action).and(this.limitedByRole.allowedIndicesMatcher(action));
    }

    @Override
    public Automaton allowedActionsMatcher(String index) {
        Automaton allowedMatcher = this.baseRole.allowedActionsMatcher(index);
        Automaton limitedByMatcher = this.limitedByRole.allowedActionsMatcher(index);
        return Automatons.intersectAndMinimize(allowedMatcher, limitedByMatcher);
    }

    @Override
    public boolean checkIndicesAction(String action) {
        return this.baseRole.checkIndicesAction(action) && this.limitedByRole.checkIndicesAction(action);
    }

    @Override
    public boolean checkIndicesPrivileges(Set<String> checkForIndexPatterns, boolean allowRestrictedIndices, Set<String> checkForPrivileges, @Nullable ResourcePrivilegesMap.Builder resourcePrivilegesMapBuilder) {
        boolean baseRoleCheck = this.baseRole.checkIndicesPrivileges(checkForIndexPatterns, allowRestrictedIndices, checkForPrivileges, resourcePrivilegesMapBuilder);
        if (!baseRoleCheck && null == resourcePrivilegesMapBuilder) {
            return false;
        }
        boolean limitedByRoleCheck = this.limitedByRole.checkIndicesPrivileges(checkForIndexPatterns, allowRestrictedIndices, checkForPrivileges, resourcePrivilegesMapBuilder);
        return baseRoleCheck && limitedByRoleCheck;
    }

    @Override
    public boolean checkClusterAction(String action, TransportRequest request, Authentication authentication) {
        return this.baseRole.checkClusterAction(action, request, authentication) && this.limitedByRole.checkClusterAction(action, request, authentication);
    }

    @Override
    public boolean grants(ClusterPrivilege clusterPrivilege) {
        return this.baseRole.grants(clusterPrivilege) && this.limitedByRole.grants(clusterPrivilege);
    }

    @Override
    public boolean checkApplicationResourcePrivileges(String applicationName, Set<String> checkForResources, Set<String> checkForPrivilegeNames, Collection<ApplicationPrivilegeDescriptor> storedPrivileges, @Nullable ResourcePrivilegesMap.Builder resourcePrivilegesMapBuilder) {
        boolean baseRoleCheck = this.baseRole.checkApplicationResourcePrivileges(applicationName, checkForResources, checkForPrivilegeNames, storedPrivileges, resourcePrivilegesMapBuilder);
        if (!baseRoleCheck && null == resourcePrivilegesMapBuilder) {
            return false;
        }
        boolean limitedByRoleCheck = this.limitedByRole.checkApplicationResourcePrivileges(applicationName, checkForResources, checkForPrivilegeNames, storedPrivileges, resourcePrivilegesMapBuilder);
        return baseRoleCheck && limitedByRoleCheck;
    }

    @Override
    public boolean checkRunAs(String runAs) {
        return this.baseRole.checkRunAs(runAs) && this.limitedByRole.checkRunAs(runAs);
    }

    public Role getBaseRole() {
        return this.baseRole;
    }

    public Role getLimitedByRole() {
        return this.limitedByRole;
    }
}

