/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.pki;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.Schema;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.support.DelegatedAuthorizationSettings;
import org.elasticsearch.xpack.core.security.authc.support.mapper.CompositeRoleMapperSettings;
import org.elasticsearch.xpack.core.ssl.SSLConfigurationSettings;

public final class PkiRealmSettings {
    public static final String TYPE = "pki";
    public static final String DEFAULT_USERNAME_PATTERN = "CN=(.*?)(?:,|$)";
    public static final Setting.AffixSetting<Pattern> USERNAME_PATTERN_SETTING = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("pki"), (String)"username_pattern", key -> new Setting(key, DEFAULT_USERNAME_PATTERN, s -> Pattern.compile(s, 2), new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<String> USERNAME_RDN_OID_SETTING = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("pki"), (String)"username_rdn_oid", key -> Setting.simpleString((String)key, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<String> USERNAME_RDN_NAME_SETTING = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("pki"), (String)"username_rdn_name", key -> new Setting(key, (String)null, s -> {
        Schema schema;
        if (s == null) {
            return "";
        }
        try {
            schema = Schema.getDefaultStandardSchema();
        }
        catch (LDAPException e) {
            throw new IllegalStateException("Unexpected error occurred obtaining default LDAP schema", e);
        }
        AttributeTypeDefinition atd = schema.getAttributeType(s);
        if (atd == null) {
            throw new IllegalArgumentException("Unknown RDN name [" + s + "] for setting [" + key + "]");
        }
        return atd.getOID();
    }, new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    private static final TimeValue DEFAULT_TTL = TimeValue.timeValueMinutes((long)20L);
    public static final Setting.AffixSetting<TimeValue> CACHE_TTL_SETTING = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("pki"), (String)"cache.ttl", key -> Setting.timeSetting((String)key, (TimeValue)DEFAULT_TTL, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    private static final int DEFAULT_MAX_USERS = 100000;
    public static final Setting.AffixSetting<Integer> CACHE_MAX_USERS_SETTING = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("pki"), (String)"cache.max_users", key -> Setting.intSetting((String)key, (int)100000, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<Boolean> DELEGATION_ENABLED_SETTING = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("pki"), (String)"delegation.enabled", key -> Setting.boolSetting((String)key, (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<Optional<String>> TRUST_STORE_PATH;
    public static final Setting.AffixSetting<Optional<String>> TRUST_STORE_TYPE;
    public static final Setting.AffixSetting<SecureString> TRUST_STORE_PASSWORD;
    public static final Setting.AffixSetting<SecureString> LEGACY_TRUST_STORE_PASSWORD;
    public static final Setting.AffixSetting<String> TRUST_STORE_ALGORITHM;
    public static final Setting.AffixSetting<List<String>> CAPATH_SETTING;

    private PkiRealmSettings() {
    }

    public static Set<Setting.AffixSetting<?>> getSettings() {
        HashSet settings = new HashSet();
        settings.add(USERNAME_PATTERN_SETTING);
        settings.add(USERNAME_RDN_OID_SETTING);
        settings.add(USERNAME_RDN_NAME_SETTING);
        settings.add(CACHE_TTL_SETTING);
        settings.add(CACHE_MAX_USERS_SETTING);
        settings.add(DELEGATION_ENABLED_SETTING);
        settings.add(TRUST_STORE_PATH);
        settings.add(TRUST_STORE_PASSWORD);
        settings.add(LEGACY_TRUST_STORE_PASSWORD);
        settings.add(TRUST_STORE_ALGORITHM);
        settings.add(CAPATH_SETTING);
        settings.addAll(DelegatedAuthorizationSettings.getSettings(TYPE));
        settings.addAll(CompositeRoleMapperSettings.getSettings(TYPE));
        settings.addAll(RealmSettings.getStandardSettings(TYPE));
        return settings;
    }

    static {
        String prefix = "xpack.security.authc.realms.pki.";
        TRUST_STORE_PATH = SSLConfigurationSettings.TRUSTSTORE_PATH.affixSetting("xpack.security.authc.realms.pki.", "");
        TRUST_STORE_TYPE = SSLConfigurationSettings.TRUSTSTORE_TYPE.affixSetting("xpack.security.authc.realms.pki.", "");
        TRUST_STORE_PASSWORD = SSLConfigurationSettings.TRUSTSTORE_PASSWORD.affixSetting("xpack.security.authc.realms.pki.", "");
        LEGACY_TRUST_STORE_PASSWORD = SSLConfigurationSettings.LEGACY_TRUSTSTORE_PASSWORD.affixSetting("xpack.security.authc.realms.pki.", "");
        TRUST_STORE_ALGORITHM = SSLConfigurationSettings.TRUSTSTORE_ALGORITHM.affixSetting("xpack.security.authc.realms.pki.", "");
        CAPATH_SETTING = SSLConfigurationSettings.CERT_AUTH_PATH.affixSetting("xpack.security.authc.realms.pki.", "");
    }
}

