/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.user;

import java.io.IOException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.security.action.user.UserRequest;
import org.elasticsearch.xpack.core.security.authz.store.RoleReference;

public final class GetUserPrivilegesRequest
extends LegacyActionRequest
implements UserRequest {
    private static final TransportVersion TV_UNWRAP_ROLE = TransportVersion.fromName((String)"get_user_priv_unwrap_role");
    private String username;
    @Nullable
    private RoleReference.ApiKeyRoleType unwrapInnerRole;

    GetUserPrivilegesRequest() {
    }

    public GetUserPrivilegesRequest(StreamInput in) throws IOException {
        super(in);
        this.username = in.readString();
        this.unwrapInnerRole = in.getTransportVersion().supports(TV_UNWRAP_ROLE) ? (RoleReference.ApiKeyRoleType)in.readOptionalEnum(RoleReference.ApiKeyRoleType.class) : null;
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public String username() {
        return this.username;
    }

    public void username(String username) {
        this.username = username;
    }

    @Override
    public String[] usernames() {
        return new String[]{this.username};
    }

    public RoleReference.ApiKeyRoleType unwrapLimitedRole() {
        return this.unwrapInnerRole;
    }

    public void unwrapLimitedRole(RoleReference.ApiKeyRoleType unwrapInnerRole) {
        this.unwrapInnerRole = unwrapInnerRole;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.username);
        if (out.getTransportVersion().supports(TV_UNWRAP_ROLE)) {
            out.writeOptionalEnum((Enum)this.unwrapInnerRole);
        }
    }
}

