/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.apikey;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.security.action.apikey.ApiKey;
import org.elasticsearch.xpack.core.security.action.apikey.CertificateIdentity;
import org.elasticsearch.xpack.core.security.action.role.RoleDescriptorRequestValidator;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.support.MetadataUtils;

public abstract class BaseUpdateApiKeyRequest
extends LegacyActionRequest {
    @Nullable
    protected final List<RoleDescriptor> roleDescriptors;
    @Nullable
    protected final Map<String, Object> metadata;
    @Nullable
    protected final TimeValue expiration;
    @Nullable
    protected final CertificateIdentity certificateIdentity;

    public BaseUpdateApiKeyRequest(@Nullable List<RoleDescriptor> roleDescriptors, @Nullable Map<String, Object> metadata, @Nullable TimeValue expiration, @Nullable CertificateIdentity certificateIdentity) {
        this.roleDescriptors = roleDescriptors;
        this.metadata = metadata;
        this.expiration = expiration;
        this.certificateIdentity = certificateIdentity;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public List<RoleDescriptor> getRoleDescriptors() {
        return this.roleDescriptors;
    }

    public TimeValue getExpiration() {
        return this.expiration;
    }

    public CertificateIdentity getCertificateIdentity() {
        return this.certificateIdentity;
    }

    public abstract ApiKey.Type getType();

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.metadata != null && MetadataUtils.containsReservedMetadata(this.metadata)) {
            validationException = ValidateActions.addValidationError((String)"API key metadata keys may not start with [_]", validationException);
        }
        if (this.roleDescriptors != null) {
            for (RoleDescriptor roleDescriptor : this.roleDescriptors) {
                validationException = RoleDescriptorRequestValidator.validate(roleDescriptor, validationException);
            }
        }
        if (this.expiration != null && this.expiration.nanos() <= 0L) {
            validationException = ValidateActions.addValidationError((String)"API key expiration must be in the future", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public final void writeTo(StreamOutput out) throws IOException {
        TransportAction.localOnly();
    }
}

