/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe;

import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.common.time.TimeUtils;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsState;
import org.elasticsearch.xpack.core.ml.utils.MlTaskState;

public class DataFrameAnalyticsTaskState
implements PersistentTaskState,
MlTaskState {
    public static final String NAME = "xpack/ml/data_frame/analytics";
    private static final ParseField STATE = new ParseField("state", new String[0]);
    private static final ParseField ALLOCATION_ID = new ParseField("allocation_id", new String[0]);
    private static final ParseField REASON = new ParseField("reason", new String[0]);
    private static final ParseField LAST_STATE_CHANGE_TIME = new ParseField("last_state_change_time", new String[0]);
    private final DataFrameAnalyticsState state;
    private final long allocationId;
    private final String reason;
    private final Instant lastStateChangeTime;
    private static final ConstructingObjectParser<DataFrameAnalyticsTaskState, Void> PARSER = new ConstructingObjectParser("xpack/ml/data_frame/analytics", true, a -> new DataFrameAnalyticsTaskState((DataFrameAnalyticsState)a[0], (Long)a[1], (String)a[2], (Instant)a[3]));

    public static DataFrameAnalyticsTaskState fromXContent(XContentParser parser) {
        try {
            return (DataFrameAnalyticsTaskState)PARSER.parse(parser, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public DataFrameAnalyticsTaskState(DataFrameAnalyticsState state, long allocationId, @Nullable String reason, @Nullable Instant lastStateChangeTime) {
        this.state = Objects.requireNonNull(state);
        this.allocationId = allocationId;
        this.reason = reason;
        this.lastStateChangeTime = lastStateChangeTime != null ? Instant.ofEpochMilli(lastStateChangeTime.toEpochMilli()) : null;
    }

    public DataFrameAnalyticsTaskState(StreamInput in) throws IOException {
        this.state = DataFrameAnalyticsState.fromStream(in);
        this.allocationId = in.readLong();
        this.reason = in.readOptionalString();
        this.lastStateChangeTime = in.readOptionalInstant();
    }

    public DataFrameAnalyticsState getState() {
        return this.state;
    }

    public long getAllocationId() {
        return this.allocationId;
    }

    @Nullable
    public String getReason() {
        return this.reason;
    }

    @Override
    @Nullable
    public Instant getLastStateChangeTime() {
        return this.lastStateChangeTime;
    }

    @Override
    public boolean isFailed() {
        return DataFrameAnalyticsState.FAILED.equals(this.state);
    }

    public boolean isStatusStale(PersistentTasksCustomMetadata.PersistentTask<?> task) {
        return this.allocationId != task.getAllocationId();
    }

    public String getWriteableName() {
        return NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.state.writeTo(out);
        out.writeLong(this.allocationId);
        out.writeOptionalString(this.reason);
        out.writeOptionalInstant(this.lastStateChangeTime);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(STATE.getPreferredName(), this.state.toString());
        builder.field(ALLOCATION_ID.getPreferredName(), this.allocationId);
        if (this.reason != null) {
            builder.field(REASON.getPreferredName(), this.reason);
        }
        if (this.lastStateChangeTime != null) {
            builder.timestampFieldsFromUnixEpochMillis(LAST_STATE_CHANGE_TIME.getPreferredName(), LAST_STATE_CHANGE_TIME.getPreferredName() + "_string", this.lastStateChangeTime.toEpochMilli());
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataFrameAnalyticsTaskState that = (DataFrameAnalyticsTaskState)o;
        return this.allocationId == that.allocationId && this.state == that.state && Objects.equals(this.reason, that.reason) && Objects.equals(this.lastStateChangeTime, that.lastStateChangeTime);
    }

    public int hashCode() {
        return Objects.hash(this.state, this.allocationId, this.reason, this.lastStateChangeTime);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), DataFrameAnalyticsState::fromString, STATE);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), ALLOCATION_ID);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), REASON);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> TimeUtils.parseTimeFieldToInstant(p, LAST_STATE_CHANGE_TIME.getPreferredName()), LAST_STATE_CHANGE_TIME, ObjectParser.ValueType.VALUE);
    }
}

