/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.action.StartTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class StopTrainedModelDeploymentAction
extends ActionType<Response> {
    public static final StopTrainedModelDeploymentAction INSTANCE = new StopTrainedModelDeploymentAction();
    public static final String NAME = "cluster:admin/xpack/ml/trained_models/deployment/stop";

    public StopTrainedModelDeploymentAction() {
        super(NAME);
    }

    public static class Response
    extends BaseTasksResponse
    implements Writeable,
    ToXContentObject {
        private final boolean undeployed;

        public Response(boolean undeployed) {
            super(null, null);
            this.undeployed = undeployed;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.undeployed = in.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.undeployed);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.toXContentCommon(builder, params);
            builder.field("stopped", this.undeployed);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.undeployed);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response that = (Response)((Object)o);
            return this.undeployed == that.undeployed;
        }
    }

    public static class Request
    extends BaseTasksRequest<Request>
    implements ToXContentObject {
        public static final ParseField ALLOW_NO_MATCH = new ParseField("allow_no_match", new String[0]);
        public static final ParseField FORCE = new ParseField("force", new String[0]);
        public static final ParseField FINISH_PENDING_WORK = new ParseField("finish_pending_work", new String[0]);
        private String id;
        private boolean allowNoMatch = true;
        private boolean force;
        private boolean finishPendingWork;
        private static final ObjectParser<Request, Void> PARSER = new ObjectParser("cluster:admin/xpack/ml/trained_models/deployment/stop", Request::new);

        public static Request parseRequest(String id, XContentParser parser) {
            Request request = (Request)((Object)PARSER.apply(parser, null));
            if (request.getId() == null) {
                request.setId(id);
            } else if (!Strings.isNullOrEmpty((String)id) && !id.equals(request.getId())) {
                throw new IllegalArgumentException(Messages.getMessage("Inconsistent {0}; ''{1}'' specified in the body differs from ''{2}'' specified as a URL argument", TrainedModelConfig.MODEL_ID, request.getId(), id));
            }
            return request;
        }

        public Request(String id) {
            this.setId(id);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.id = in.readString();
            this.allowNoMatch = in.readBoolean();
            this.force = in.readBoolean();
            this.finishPendingWork = in.readBoolean();
        }

        private Request() {
        }

        public final void setId(String id) {
            this.id = ExceptionsHelper.requireNonNull(id, TrainedModelConfig.MODEL_ID);
        }

        public String getId() {
            return this.id;
        }

        public void setAllowNoMatch(boolean allowNoMatch) {
            this.allowNoMatch = allowNoMatch;
        }

        public boolean isAllowNoMatch() {
            return this.allowNoMatch;
        }

        public void setForce(boolean force) {
            this.force = force;
        }

        public boolean isForce() {
            return this.force;
        }

        public boolean shouldFinishPendingWork() {
            return this.finishPendingWork;
        }

        public void setFinishPendingWork(boolean finishPendingWork) {
            this.finishPendingWork = finishPendingWork;
        }

        public boolean match(Task task) {
            return StartTrainedModelDeploymentAction.TaskMatcher.match(task, this.id);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.id);
            out.writeBoolean(this.allowNoMatch);
            out.writeBoolean(this.force);
            out.writeBoolean(this.finishPendingWork);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(TrainedModelConfig.MODEL_ID.getPreferredName(), this.id);
            builder.field(ALLOW_NO_MATCH.getPreferredName(), this.allowNoMatch);
            builder.field(FORCE.getPreferredName(), this.force);
            builder.field(FINISH_PENDING_WORK.getPreferredName(), this.finishPendingWork);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.id, this.allowNoMatch, this.force, this.finishPendingWork);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request that = (Request)((Object)o);
            return Objects.equals(this.id, that.id) && this.allowNoMatch == that.allowNoMatch && this.force == that.force && this.finishPendingWork == that.finishPendingWork;
        }

        static {
            PARSER.declareString(Request::setId, TrainedModelConfig.MODEL_ID);
            PARSER.declareBoolean(Request::setAllowNoMatch, ALLOW_NO_MATCH);
            PARSER.declareBoolean(Request::setForce, FORCE);
            PARSER.declareBoolean(Request::setFinishPendingWork, FINISH_PENDING_WORK);
        }
    }
}

