/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.chunking;

import org.elasticsearch.inference.ChunkingStrategy;
import org.elasticsearch.xpack.core.inference.chunking.Chunker;
import org.elasticsearch.xpack.core.inference.chunking.NoopChunker;
import org.elasticsearch.xpack.core.inference.chunking.RecursiveChunker;
import org.elasticsearch.xpack.core.inference.chunking.SentenceBoundaryChunker;
import org.elasticsearch.xpack.core.inference.chunking.WordBoundaryChunker;

public class ChunkerBuilder {
    public static Chunker fromChunkingStrategy(ChunkingStrategy chunkingStrategy) {
        if (chunkingStrategy == null) {
            return new WordBoundaryChunker();
        }
        return switch (chunkingStrategy) {
            default -> throw new MatchException(null, null);
            case ChunkingStrategy.NONE -> NoopChunker.INSTANCE;
            case ChunkingStrategy.WORD -> new WordBoundaryChunker();
            case ChunkingStrategy.SENTENCE -> new SentenceBoundaryChunker();
            case ChunkingStrategy.RECURSIVE -> new RecursiveChunker();
        };
    }
}

