/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.jdbc;

import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.TimeZone;

final class DebugLog {
    private static final String HEADER = "%tF/%tT.%tL - ";
    final PrintWriter print;
    private boolean flushAlways;

    DebugLog(PrintWriter print, boolean flushAlways) {
        this.print = print;
        this.flushAlways = flushAlways;
    }

    void logMethod(Method m, Object[] args) {
        long time = System.currentTimeMillis();
        this.print.printf(Locale.ROOT, "%tF/%tT.%tL - Invoke %s#%s(%s)%n", time, time, time, m.getDeclaringClass().getSimpleName(), m.getName(), DebugLog.array(args));
        if (this.flushAlways) {
            this.print.flush();
        }
    }

    void logResult(Method m, Object[] args, Object r) {
        long time = System.currentTimeMillis();
        this.print.printf(Locale.ROOT, "%tF/%tT.%tL - %s#%s(%s) returned %s%n", time, time, time, m.getDeclaringClass().getSimpleName(), m.getName(), DebugLog.array(args), r);
        if (this.flushAlways) {
            this.print.flush();
        }
    }

    void logException(Method m, Object[] args, Throwable t) {
        long time = System.currentTimeMillis();
        this.print.printf(Locale.ROOT, "%tF/%tT.%tL - %s#%s(%s) threw ", time, time, time, m.getDeclaringClass().getSimpleName(), m.getName(), DebugLog.array(args));
        t.printStackTrace(this.print);
        this.print.flush();
    }

    void logSystemInfo() {
        long time = System.currentTimeMillis();
        this.print.printf(Locale.ROOT, "%tF/%tT.%tL - OS[%s/%s/%s], JVM[%s/%s/%s/%s]", time, time, time, System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"), System.getProperty("java.vm.vendor"), System.getProperty("java.vm.name"), System.getProperty("java.version"), System.getProperty("java.vm.version"));
        this.print.println();
        time = System.currentTimeMillis();
        this.print.printf(Locale.ROOT, "%tF/%tT.%tL - JVM default timezone: %s", time, time, time, TimeZone.getDefault().toString());
        this.print.println();
        this.print.flush();
    }

    private static String array(Object[] a) {
        if (a == null || a.length == 0) {
            return "";
        }
        if (a.length == 1) {
            return DebugLog.handleArray(a[0]);
        }
        StringBuilder b = new StringBuilder();
        int iMax = a.length - 1;
        int i = 0;
        while (true) {
            b.append(DebugLog.handleArray(a[i]));
            if (i == iMax) {
                return b.toString();
            }
            b.append(", ");
            ++i;
        }
    }

    private static String handleArray(Object o) {
        if (o != null && o.getClass().isArray()) {
            StringBuilder b = new StringBuilder();
            int l = Array.getLength(o);
            int iMax = l - 1;
            if (iMax == -1) {
                return "[]";
            }
            b.append('[');
            for (int i = 0; i < l; ++i) {
                b.append(DebugLog.handleArray(Array.get(o, i)));
                if (i == iMax) {
                    return b.append("]").toString();
                }
                b.append(", ");
            }
        }
        return String.valueOf(o);
    }
}

