/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.view;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.local.LocalClusterStateRequest;
import org.elasticsearch.cluster.metadata.View;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetViewAction
extends ActionType<Response> {
    public static final GetViewAction INSTANCE = new GetViewAction();
    public static final String NAME = "cluster:admin/xpack/esql/view/get";

    private GetViewAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final Collection<View> views;

        public Response(Collection<View> views) {
            Objects.requireNonNull(views, "views cannot be null");
            this.views = Collections.unmodifiableCollection(views);
        }

        public Collection<View> getViews() {
            return this.views;
        }

        public void writeTo(StreamOutput out) throws IOException {
            TransportAction.localOnly();
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            Iterator v = ChunkedToXContentHelper.array((String)"views", this.views.iterator());
            while (v.hasNext()) {
                ((ToXContent)v.next()).toXContent(builder, params);
            }
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            return this.views.equals(((Response)((Object)o)).views);
        }

        public int hashCode() {
            return this.views.hashCode();
        }

        public String toString() {
            return "GetViewAction.Response" + String.valueOf(this.views.stream().map(View::name).toList());
        }
    }

    public static class Request
    extends LocalClusterStateRequest {
        private final List<String> names;

        public Request(TimeValue masterNodeTimeout, String ... names) {
            super(masterNodeTimeout);
            this.names = List.of(names);
        }

        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, this.getDescription(), parentTaskId, headers);
        }

        public List<String> names() {
            return this.names;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.names, request.names);
        }

        public int hashCode() {
            return Objects.hash(this.names);
        }
    }
}

