/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.telemetry;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.xpack.esql.capabilities.TelemetryAware;
import org.elasticsearch.xpack.esql.core.expression.function.Function;
import org.elasticsearch.xpack.esql.core.util.Check;
import org.elasticsearch.xpack.esql.expression.function.EsqlFunctionRegistry;

public class PlanTelemetry {
    private final EsqlFunctionRegistry functionRegistry;
    private final Map<String, Integer> commands = new HashMap<String, Integer>();
    private final Map<String, Integer> functions = new HashMap<String, Integer>();

    public PlanTelemetry(EsqlFunctionRegistry functionRegistry) {
        this.functionRegistry = functionRegistry;
    }

    private void add(Map<String, Integer> map, String key) {
        map.compute(key.toUpperCase(Locale.ROOT), (k, count) -> count == null ? 1 : count + 1);
    }

    public void command(TelemetryAware command) {
        Check.notNull(command.telemetryLabel(), "TelemetryAware [{}] has no telemetry label", command);
        this.add(this.commands, command.telemetryLabel());
    }

    public void function(String name) {
        String functionName = this.functionRegistry.resolveAlias(name);
        if (this.functionRegistry.functionExists(functionName)) {
            this.add(this.functions, functionName);
        }
    }

    public void function(Class<? extends Function> clazz) {
        this.add(this.functions, this.functionRegistry.snapshotRegistry().functionName(clazz));
    }

    public Map<String, Integer> commands() {
        return this.commands;
    }

    public Map<String, Integer> functions() {
        return this.functions;
    }
}

