/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.session;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.EmptyAttribute;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.MetadataAttribute;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.expression.ReferenceAttribute;
import org.elasticsearch.xpack.esql.core.expression.UnresolvedPattern;
import org.elasticsearch.xpack.esql.core.expression.UnresolvedStar;
import org.elasticsearch.xpack.esql.core.expression.UnresolvedTimestamp;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.expression.UnresolvedNamePattern;
import org.elasticsearch.xpack.esql.expression.function.UnresolvedFunction;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.Drop;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Filter;
import org.elasticsearch.xpack.esql.plan.logical.Fork;
import org.elasticsearch.xpack.esql.plan.logical.InlineStats;
import org.elasticsearch.xpack.esql.plan.logical.Insist;
import org.elasticsearch.xpack.esql.plan.logical.Keep;
import org.elasticsearch.xpack.esql.plan.logical.Limit;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.MvExpand;
import org.elasticsearch.xpack.esql.plan.logical.OrderBy;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.logical.RegexExtract;
import org.elasticsearch.xpack.esql.plan.logical.Rename;
import org.elasticsearch.xpack.esql.plan.logical.TopN;
import org.elasticsearch.xpack.esql.plan.logical.UnionAll;
import org.elasticsearch.xpack.esql.plan.logical.UnresolvedRelation;
import org.elasticsearch.xpack.esql.plan.logical.inference.Completion;
import org.elasticsearch.xpack.esql.plan.logical.join.LookupJoin;
import org.elasticsearch.xpack.esql.session.EsqlSession;
import org.elasticsearch.xpack.esql.session.IndexResolver;

public class FieldNameUtils {
    private static final Set<String> FUNCTIONS_REQUIRING_TIMESTAMP = Set.of("TBucket".toLowerCase(Locale.ROOT), "TRange".toLowerCase(Locale.ROOT));

    public static EsqlSession.PreAnalysisResult resolveFieldNames(LogicalPlan parsed, boolean hasEnriches) {
        List<LogicalPlan> inlinestats = parsed.collect(InlineStats.class::isInstance);
        HashSet<Aggregate> inlinestatsAggs = new HashSet<Aggregate>();
        for (LogicalPlan i : inlinestats) {
            inlinestatsAggs.add(((InlineStats)i).aggregate());
        }
        if (!parsed.anyMatch(p -> FieldNameUtils.shouldCollectReferencedFields(p, inlinestatsAggs))) {
            return new EsqlSession.PreAnalysisResult(IndexResolver.ALL_FIELDS, Set.of());
        }
        Holder projectAll = new Holder((Object)false);
        parsed.forEachExpressionDown(UnresolvedStar.class, us -> {
            if (((Boolean)projectAll.get()).booleanValue()) {
                return;
            }
            projectAll.set((Object)true);
        });
        if (((Boolean)projectAll.get()).booleanValue()) {
            return new EsqlSession.PreAnalysisResult(IndexResolver.ALL_FIELDS, Set.of());
        }
        Holder referencesBuilder = new Holder((Object)AttributeSet.builder());
        AttributeSet.Builder keepRefs = AttributeSet.builder();
        AttributeSet.Builder dropWildcardRefs = AttributeSet.builder();
        AttributeSet.Builder joinRefs = AttributeSet.builder();
        HashSet<String> wildcardJoinIndices = new HashSet<String>();
        Holder canRemoveAliases = new Holder((Object)true);
        Holder forEachDownProcessor = new Holder();
        Holder lastSeenFork = new Holder(null);
        forEachDownProcessor.set((p, breakEarly) -> {
            if (p instanceof Fork) {
                Fork fork = (Fork)p;
                AttributeSet.Builder forkRefsResult = AttributeSet.builder();
                forkRefsResult.addAll((AttributeSet.Builder)referencesBuilder.get());
                for (LogicalPlan forkBranch : fork.children()) {
                    referencesBuilder.set((Object)AttributeSet.builder());
                    boolean isNestedFork = forkBranch.forEachDownMayReturnEarly((BiConsumer)forEachDownProcessor.get());
                    LogicalPlan lastFork = (LogicalPlan)lastSeenFork.get();
                    if (lastFork != null && !(fork instanceof UnionAll) && !(lastFork instanceof UnionAll)) assert (!isNestedFork) : "Nested FORKs are not yet supported";
                    if (((AttributeSet.Builder)referencesBuilder.get()).isEmpty()) {
                        projectAll.set((Object)true);
                        breakEarly.set((Object)true);
                        lastSeenFork.set((Object)fork);
                        return;
                    }
                    forkRefsResult.addAll((AttributeSet.Builder)referencesBuilder.get());
                }
                forkRefsResult.removeIf(attr -> attr.name().equals("_fork"));
                referencesBuilder.set((Object)forkRefsResult);
                breakEarly.set((Object)true);
                lastSeenFork.set((Object)fork);
                return;
            }
            if (p instanceof RegexExtract) {
                RegexExtract re = (RegexExtract)p;
                ((AttributeSet.Builder)referencesBuilder.get()).addAll(re.input().references());
            } else if (p instanceof Enrich) {
                Enrich enrich = (Enrich)p;
                AttributeSet enrichFieldRefs = Expressions.references(enrich.enrichFields());
                AttributeSet.Builder enrichRefs = enrichFieldRefs.combine(enrich.matchField().references()).asBuilder();
                enrichRefs.removeIf(attr -> attr instanceof EmptyAttribute);
                ((AttributeSet.Builder)referencesBuilder.get()).addAll(enrichRefs);
            } else if (p instanceof LookupJoin) {
                LookupJoin join = (LookupJoin)p;
                joinRefs.addAll(join.config().leftFields());
                if (join.config().joinOnConditions() != null) {
                    joinRefs.addAll(join.config().joinOnConditions().references());
                }
                if (keepRefs.isEmpty()) {
                    wildcardJoinIndices.add(((UnresolvedRelation)join.right()).indexPattern().indexPattern());
                } else {
                    joinRefs.addAll(keepRefs);
                }
            } else {
                UnresolvedRelation ur;
                ((AttributeSet.Builder)referencesBuilder.get()).addAll(p.references());
                if (p instanceof UnresolvedRelation && (ur = (UnresolvedRelation)p).isTimeSeriesMode()) {
                    ((AttributeSet.Builder)referencesBuilder.get()).add(UnresolvedTimestamp.withSource(ur.source()));
                }
                p.forEachExpression(UnresolvedFunction.class, uf -> {
                    if (FUNCTIONS_REQUIRING_TIMESTAMP.contains(uf.name().toLowerCase(Locale.ROOT))) {
                        ((AttributeSet.Builder)referencesBuilder.get()).add(UnresolvedTimestamp.withSource(uf.source()));
                    }
                });
                p.forEachExpression(UnresolvedNamePattern.class, up -> {
                    UnresolvedPattern ua = new UnresolvedPattern(up.source(), up.name());
                    ((AttributeSet.Builder)referencesBuilder.get()).add(ua);
                    if (p instanceof Keep) {
                        keepRefs.add(ua);
                    } else if (p instanceof Drop) {
                        dropWildcardRefs.add(ua);
                    } else {
                        throw new IllegalStateException("Only KEEP and DROP should allow wildcards");
                    }
                });
                if (p instanceof Keep) {
                    keepRefs.addAll(p.references());
                }
            }
            if (((Boolean)canRemoveAliases.get()).booleanValue() && p.anyMatch(FieldNameUtils::couldOverrideAliases)) {
                canRemoveAliases.set((Object)false);
            }
            if (((Boolean)canRemoveAliases.get()).booleanValue()) {
                AttributeSet planRefs = p.references();
                Set<String> fieldNames = planRefs.names();
                p.forEachExpressionDown(NamedExpression.class, ne -> {
                    if (!(ne instanceof Alias || ne instanceof ReferenceAttribute)) {
                        return;
                    }
                    if (fieldNames.contains(ne.name())) {
                        return;
                    }
                    ((AttributeSet.Builder)referencesBuilder.get()).removeIf(attr -> FieldNameUtils.matchByName(attr, ne.name(), keepRefs.contains(attr) || dropWildcardRefs.contains(attr)));
                });
            }
        });
        parsed.forEachDownMayReturnEarly((BiConsumer)forEachDownProcessor.get());
        if (((Boolean)projectAll.get()).booleanValue()) {
            return new EsqlSession.PreAnalysisResult(IndexResolver.ALL_FIELDS, Set.of());
        }
        ((AttributeSet.Builder)referencesBuilder.get()).addAll(joinRefs);
        ((AttributeSet.Builder)referencesBuilder.get()).removeIf(a -> a instanceof MetadataAttribute || MetadataAttribute.isSupported(a.name()));
        Set<String> fieldNames = ((AttributeSet.Builder)referencesBuilder.get()).build().names();
        if (hasEnriches) {
            return new EsqlSession.PreAnalysisResult(IndexResolver.ALL_FIELDS, wildcardJoinIndices);
        }
        if (fieldNames.isEmpty()) {
            return new EsqlSession.PreAnalysisResult(IndexResolver.INDEX_METADATA_FIELD, wildcardJoinIndices);
        }
        HashSet<String> allFields = new HashSet<String>(fieldNames.stream().flatMap(FieldNameUtils::withSubfields).collect(Collectors.toSet()));
        allFields.add("_index");
        return new EsqlSession.PreAnalysisResult(allFields, wildcardJoinIndices);
    }

    private static Stream<String> withSubfields(String name) {
        return name.endsWith("*") ? Stream.of(name) : Stream.of(name, name + ".*");
    }

    private static boolean shouldCollectReferencedFields(LogicalPlan plan, Set<Aggregate> inlinestatsAggs) {
        Aggregate agg;
        return plan instanceof Project || plan instanceof Aggregate && !inlinestatsAggs.contains(agg = (Aggregate)plan);
    }

    private static boolean couldOverrideAliases(LogicalPlan p) {
        return !(p instanceof Aggregate || p instanceof Completion || p instanceof Drop || p instanceof Eval || p instanceof Filter || p instanceof Fork || p instanceof InlineStats || p instanceof Insist || p instanceof Keep || p instanceof Limit || p instanceof MvExpand || p instanceof OrderBy || p instanceof Project || p instanceof RegexExtract || p instanceof Rename || p instanceof TopN || p instanceof UnresolvedRelation);
    }

    private static boolean matchByName(Attribute attr, String other, boolean skipIfPattern) {
        boolean isPattern = Regex.isSimpleMatchPattern((String)attr.name());
        if (skipIfPattern && isPattern) {
            return false;
        }
        String name = attr.name();
        return isPattern ? Regex.simpleMatch((String)name, (String)other) : name.equals(other);
    }
}

