/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.score;

import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.lucene.IndexedByShardId;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.ScoreOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.planner.EsPhysicalOperationProviders;
import org.elasticsearch.xpack.esql.score.ExpressionScoreMapper;

public class ScoreMapper {
    public static ScoreOperator.ExpressionScorer.Factory toScorer(Expression expression, final IndexedByShardId<? extends EsPhysicalOperationProviders.ShardContext> shardContexts) {
        if (expression instanceof ExpressionScoreMapper) {
            ExpressionScoreMapper mapper = (ExpressionScoreMapper)((Object)expression);
            return mapper.toScorer(new ExpressionScoreMapper.ToScorer(){

                @Override
                public ScoreOperator.ExpressionScorer.Factory toScorer(Expression expression) {
                    return ScoreMapper.toScorer(expression, (IndexedByShardId<? extends EsPhysicalOperationProviders.ShardContext>)shardContexts);
                }

                @Override
                public IndexedByShardId<? extends EsPhysicalOperationProviders.ShardContext> shardContexts() {
                    return shardContexts;
                }
            });
        }
        return page -> new DefaultScoreMapper().get(page);
    }

    public static class DefaultScoreMapper
    implements ScoreOperator.ExpressionScorer.Factory {
        public ScoreOperator.ExpressionScorer get(final DriverContext driverContext) {
            return new ScoreOperator.ExpressionScorer(){

                public DoubleBlock score(Page page) {
                    return driverContext.blockFactory().newConstantDoubleBlockWith(0.0, page.getPositionCount());
                }

                public void close() {
                }
            };
        }
    }
}

