/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.querydsl.query;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.kql.query.KqlQueryBuilder;

public class KqlQuery
extends Query {
    private static final Map<String, BiConsumer<KqlQueryBuilder, Object>> BUILDER_APPLIERS = Map.ofEntries(Map.entry(KqlQueryBuilder.TIME_ZONE_FIELD.getPreferredName(), (qb, v) -> qb.timeZone((String)v)), Map.entry(KqlQueryBuilder.DEFAULT_FIELD_FIELD.getPreferredName(), (qb, v) -> qb.defaultField((String)v)), Map.entry(KqlQueryBuilder.CASE_INSENSITIVE_FIELD.getPreferredName(), (qb, v) -> qb.caseInsensitive(((Boolean)v).booleanValue())), Map.entry(AbstractQueryBuilder.BOOST_FIELD.getPreferredName(), (qb, v) -> qb.boost(((Number)v).floatValue())));
    private final String query;
    private final Map<String, Object> options;

    public KqlQuery(Source source, String query, Map<String, Object> options) {
        super(source);
        this.query = query;
        this.options = options == null ? Collections.emptyMap() : Map.copyOf(options);
    }

    @Override
    protected QueryBuilder asBuilder() {
        KqlQueryBuilder queryBuilder = new KqlQueryBuilder(this.query);
        this.options.forEach((k, v) -> {
            if (!BUILDER_APPLIERS.containsKey(k)) {
                throw new IllegalArgumentException("illegal kql query option [" + k + "]");
            }
            BUILDER_APPLIERS.get(k).accept(queryBuilder, v);
        });
        return queryBuilder;
    }

    @Override
    public boolean containsPlan() {
        return false;
    }

    public String query() {
        return this.query;
    }

    public Map<String, Object> options() {
        return this.options;
    }

    @Override
    public boolean scorable() {
        return true;
    }

    @Override
    protected String innerToString() {
        return this.query;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.query, this.options);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        KqlQuery other = (KqlQuery)obj;
        return Objects.equals(this.query, other.query) && Objects.equals(this.options, other.options);
    }
}

