/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchWrapperException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.NotSerializableExceptionWrapper;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockFactoryProvider;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.async.GetAsyncResultRequest;
import org.elasticsearch.xpack.esql.VerificationException;
import org.elasticsearch.xpack.esql.action.EsqlQueryResponse;
import org.elasticsearch.xpack.esql.action.EsqlQueryTask;
import org.elasticsearch.xpack.esql.core.plugin.AbstractTransportQlAsyncGetResultsAction;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.parser.ParsingException;

public class TransportEsqlAsyncGetResultsAction
extends AbstractTransportQlAsyncGetResultsAction<EsqlQueryResponse, EsqlQueryTask> {
    private final BlockFactory blockFactory;
    private final ThreadPool threadPool;
    static final String PARSE_EX_NAME = ElasticsearchException.getExceptionName((Throwable)((Object)new ParsingException(Source.EMPTY, "", new Object[0])));
    static final String VERIFY_EX_NAME = ElasticsearchException.getExceptionName((Throwable)((Object)new VerificationException("", new Object[0])));

    @Inject
    public TransportEsqlAsyncGetResultsAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, NamedWriteableRegistry registry, Client client, BigArrays bigArrays, BlockFactoryProvider blockFactoryProvider, ThreadPool threadPool) {
        super("indices:data/read/esql/async/get", transportService, actionFilters, clusterService, registry, client, threadPool, bigArrays, EsqlQueryTask.class);
        this.blockFactory = blockFactoryProvider.blockFactory();
        this.threadPool = threadPool;
    }

    @Override
    protected void doExecute(Task task, GetAsyncResultRequest request, ActionListener<EsqlQueryResponse> listener) {
        super.doExecute(task, request, this.unwrapListener(request.getId(), listener));
    }

    @Override
    public Writeable.Reader<EsqlQueryResponse> responseReader() {
        return EsqlQueryResponse.reader(this.blockFactory);
    }

    ActionListener<EsqlQueryResponse> unwrapListener(final String asyncExecutionId, final ActionListener<EsqlQueryResponse> listener) {
        return new ActionListener<EsqlQueryResponse>(){

            public void onResponse(EsqlQueryResponse response) {
                boolean isRunning = response.isRunning();
                TransportEsqlAsyncGetResultsAction.this.threadPool.getThreadContext().addResponseHeader("X-Elasticsearch-Async-Is-Running", isRunning ? "?1" : "?0");
                TransportEsqlAsyncGetResultsAction.this.threadPool.getThreadContext().addResponseHeader("X-Elasticsearch-Async-Id", asyncExecutionId);
                listener.onResponse((Object)response);
            }

            public void onFailure(Exception e) {
                if (e instanceof ElasticsearchWrapperException && e instanceof ElasticsearchException) {
                    ElasticsearchException ee = (ElasticsearchException)e;
                    e = TransportEsqlAsyncGetResultsAction.unwrapEsException(ee);
                }
                if (e instanceof NotSerializableExceptionWrapper) {
                    NotSerializableExceptionWrapper wrapper = (NotSerializableExceptionWrapper)e;
                    String name = wrapper.getExceptionName();
                    if (PARSE_EX_NAME.equals(name)) {
                        e = new ParsingException(Source.EMPTY, ((Throwable)e).getMessage(), new Object[0]);
                        ((Throwable)e).setStackTrace(wrapper.getStackTrace());
                        ((Throwable)e).addSuppressed((Throwable)wrapper);
                    } else if (VERIFY_EX_NAME.contains(name)) {
                        e = new VerificationException(((Throwable)e).getMessage(), new Object[0]);
                        ((Throwable)e).setStackTrace(wrapper.getStackTrace());
                        ((Throwable)e).addSuppressed((Throwable)wrapper);
                    }
                }
                listener.onFailure((Exception)e);
            }
        };
    }

    static RuntimeException unwrapEsException(ElasticsearchException esEx) {
        Throwable root = esEx.unwrapCause();
        if (root instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)root;
            return runtimeException;
        }
        return esEx;
    }
}

