/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import java.io.IOException;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.search.lookup.SourceFilter;
import org.elasticsearch.search.lookup.SourceProvider;

final class ReinitializingSourceProvider
implements SourceProvider {
    private final SourceFilter sourceFilter;
    private PerThreadSourceProvider perThreadProvider;
    private final Function<SourceFilter, SourceProvider> sourceProviderFactory;

    ReinitializingSourceProvider(Function<SourceFilter, SourceProvider> sourceProviderFactory) {
        this.sourceFilter = null;
        this.sourceProviderFactory = sourceProviderFactory;
    }

    private ReinitializingSourceProvider(SourceFilter sourceFilter, Function<SourceFilter, SourceProvider> sourceProviderFactory) {
        this.sourceFilter = sourceFilter;
        this.sourceProviderFactory = sourceProviderFactory;
    }

    public Source getSource(LeafReaderContext ctx, int doc) throws IOException {
        Thread currentThread = Thread.currentThread();
        PerThreadSourceProvider provider = this.perThreadProvider;
        if (provider == null || provider.creatingThread != currentThread || doc < provider.lastSeenDocId) {
            this.perThreadProvider = provider = new PerThreadSourceProvider(this.sourceProviderFactory.apply(this.sourceFilter), currentThread);
        }
        provider.lastSeenDocId = doc;
        return provider.source.getSource(ctx, doc);
    }

    public SourceProvider optimizedSourceProvider(SourceFilter sourceFilter) {
        return new ReinitializingSourceProvider(sourceFilter, this.sourceProviderFactory);
    }

    private static final class PerThreadSourceProvider {
        final SourceProvider source;
        final Thread creatingThread;
        int lastSeenDocId;

        private PerThreadSourceProvider(SourceProvider source, Thread creatingThread) {
            this.source = source;
            this.creatingThread = creatingThread;
        }
    }
}

