/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.Build;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.RefCountingRunnable;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.routing.SplitShardCountSummary;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.compute.lucene.IndexedByShardId;
import org.elasticsearch.compute.lucene.IndexedByShardIdFromSingleton;
import org.elasticsearch.compute.operator.DriverCompletionInfo;
import org.elasticsearch.compute.operator.PlanTimeProfile;
import org.elasticsearch.compute.operator.exchange.ExchangeService;
import org.elasticsearch.compute.operator.exchange.ExchangeSink;
import org.elasticsearch.compute.operator.exchange.ExchangeSinkHandler;
import org.elasticsearch.compute.operator.exchange.ExchangeSourceHandler;
import org.elasticsearch.compute.operator.exchange.RemoteSink;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeSinkExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.planner.PlanConcurrencyCalculator;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;
import org.elasticsearch.xpack.esql.plugin.ComputeContext;
import org.elasticsearch.xpack.esql.plugin.ComputeListener;
import org.elasticsearch.xpack.esql.plugin.ComputeResponse;
import org.elasticsearch.xpack.esql.plugin.ComputeSearchContext;
import org.elasticsearch.xpack.esql.plugin.ComputeSearchContextByShardId;
import org.elasticsearch.xpack.esql.plugin.ComputeService;
import org.elasticsearch.xpack.esql.plugin.DataNodeComputeResponse;
import org.elasticsearch.xpack.esql.plugin.DataNodeRequest;
import org.elasticsearch.xpack.esql.plugin.DataNodeRequestSender;
import org.elasticsearch.xpack.esql.plugin.EsqlFlags;
import org.elasticsearch.xpack.esql.plugin.QueryPragmas;
import org.elasticsearch.xpack.esql.plugin.ReductionPlan;
import org.elasticsearch.xpack.esql.session.Configuration;

final class DataNodeComputeHandler
implements TransportRequestHandler<DataNodeRequest> {
    private static final TransportVersion ESQL_RETRY_ON_SHARD_LEVEL_FAILURE = TransportVersion.fromName((String)"esql_retry_on_shard_level_failure");
    private final ComputeService computeService;
    private final SearchService searchService;
    private final ClusterService clusterService;
    private final ProjectResolver projectResolver;
    private final TransportService transportService;
    private final ExchangeService exchangeService;
    private final Executor esqlExecutor;
    private final ThreadPool threadPool;
    private static final Logger LOGGER = LogManager.getLogger(DataNodeComputeHandler.class);

    DataNodeComputeHandler(ComputeService computeService, ClusterService clusterService, ProjectResolver projectResolver, SearchService searchService, TransportService transportService, ExchangeService exchangeService, Executor esqlExecutor) {
        this.computeService = computeService;
        this.clusterService = clusterService;
        this.projectResolver = projectResolver;
        this.searchService = searchService;
        this.transportService = transportService;
        this.exchangeService = exchangeService;
        this.esqlExecutor = esqlExecutor;
        this.threadPool = transportService.getThreadPool();
        transportService.registerRequestHandler("indices:data/read/esql/data", esqlExecutor, DataNodeRequest::new, (TransportRequestHandler)this);
    }

    void startComputeOnDataNodes(final String sessionId, final String clusterAlias, final CancellableTask parentTask, EsqlFlags flags, final Configuration configuration, final PhysicalPlan dataNodePlan, Set<String> concreteIndices, final OriginalIndices originalIndices, final ExchangeSourceHandler exchangeSource, final Runnable runOnTaskFailure, ActionListener<ComputeResponse> outListener) {
        Integer maxConcurrentNodesPerCluster = PlanConcurrencyCalculator.INSTANCE.calculateNodesConcurrency(dataNodePlan, configuration);
        new DataNodeRequestSender(this.clusterService, this.projectResolver, this.transportService, this.esqlExecutor, parentTask, originalIndices, PlannerUtils.canMatchFilter(flags, configuration, this.clusterService.state().getMinTransportVersion(), dataNodePlan), clusterAlias, configuration.allowPartialResults(), maxConcurrentNodesPerCluster == null ? -1 : maxConcurrentNodesPerCluster, configuration.pragmas().unavailableShardResolutionAttempts()){

            @Override
            protected void sendRequest(DiscoveryNode node, List<DataNodeRequest.Shard> shards, Map<Index, AliasFilter> aliasFilters, DataNodeRequestSender.NodeListener nodeListener) {
                Transport.Connection connection;
                if (exchangeSource.isFinished()) {
                    nodeListener.onSkip();
                    return;
                }
                AtomicLong pagesFetched = new AtomicLong();
                ActionListener listener = ActionListener.wrap(nodeListener::onResponse, e -> nodeListener.onFailure((Exception)e, pagesFetched.get() > 0L));
                try {
                    connection = DataNodeComputeHandler.this.transportService.getConnection(node);
                }
                catch (Exception e2) {
                    listener.onFailure(e2);
                    return;
                }
                QueryPragmas queryPragmas = configuration.pragmas();
                String childSessionId = DataNodeComputeHandler.this.computeService.newChildSession(sessionId);
                ExchangeService.openExchange((TransportService)DataNodeComputeHandler.this.transportService, (Transport.Connection)connection, (String)childSessionId, (int)queryPragmas.exchangeBufferSize(), (Executor)DataNodeComputeHandler.this.esqlExecutor, (ActionListener)listener.delegateFailureAndWrap((l, unused) -> {
                    Runnable onGroupFailure;
                    CancellableTask groupTask;
                    if (configuration.allowPartialResults()) {
                        try {
                            groupTask = DataNodeComputeHandler.this.computeService.createGroupTask((Task)parentTask, () -> "compute group: data-node [" + node.getName() + "], shards [" + String.valueOf(shards) + "]");
                        }
                        catch (TaskCancelledException e) {
                            l.onFailure((Exception)((Object)e));
                            return;
                        }
                        onGroupFailure = DataNodeComputeHandler.this.computeService.cancelQueryOnFailure(groupTask);
                        l = ActionListener.runAfter((ActionListener)l, () -> DataNodeComputeHandler.this.transportService.getTaskManager().unregister((Task)groupTask));
                    } else {
                        groupTask = parentTask;
                        onGroupFailure = runOnTaskFailure;
                    }
                    AtomicReference nodeResponseRef = new AtomicReference();
                    try (ComputeListener computeListener = new ComputeListener(DataNodeComputeHandler.this.threadPool, onGroupFailure, (ActionListener<DriverCompletionInfo>)l.map(ignored -> (DataNodeComputeResponse)((Object)((Object)((Object)nodeResponseRef.get())))));){
                        boolean sameNodeAsCoordinator = DataNodeComputeHandler.this.transportService.getLocalNode().getId().equals(connection.getNode().getId());
                        boolean enableReduceNodeLateMaterialization = Build.current().isSnapshot();
                        DataNodeRequest dataNodeRequest = new DataNodeRequest(childSessionId, configuration, clusterAlias, shards, aliasFilters, dataNodePlan, originalIndices.indices(), originalIndices.indicesOptions(), queryPragmas.nodeLevelReduction() && !sameNodeAsCoordinator, queryPragmas.nodeLevelReduction() && enableReduceNodeLateMaterialization);
                        DataNodeComputeHandler.this.transportService.sendChildRequest(connection, "indices:data/read/esql/data", (TransportRequest)dataNodeRequest, (Task)groupTask, TransportRequestOptions.EMPTY, (TransportResponseHandler)new ActionListenerResponseHandler(computeListener.acquireCompute().map(r -> {
                            nodeResponseRef.set(r);
                            return r.completionInfo();
                        }), DataNodeComputeResponse::new, DataNodeComputeHandler.this.esqlExecutor));
                        RemoteSink remoteSink = DataNodeComputeHandler.this.exchangeService.newRemoteSink((Task)groupTask, childSessionId, DataNodeComputeHandler.this.transportService, connection);
                        exchangeSource.addRemoteSink(remoteSink, !configuration.allowPartialResults(), pagesFetched::incrementAndGet, queryPragmas.concurrentExchangeClients(), computeListener.acquireAvoid());
                    }
                }));
            }
        }.startComputeOnDataNodes(concreteIndices, runOnTaskFailure, (ActionListener<ComputeResponse>)ActionListener.releaseAfter(outListener, (Releasable)exchangeSource.addEmptySink()));
    }

    private void runComputeOnDataNode(CancellableTask task, String externalId, PhysicalPlan reducePlan, DataNodeRequest request, boolean failFastOnShardFailure, ComputeSearchContextByShardId searchContexts, PlanTimeProfile planTimeProfile, ActionListener<DataNodeComputeResponse> listener) {
        HashMap<ShardId, Exception> shardLevelFailures = new HashMap<ShardId, Exception>();
        try (ComputeListener computeListener = new ComputeListener(this.transportService.getThreadPool(), this.computeService.cancelQueryOnFailure(task), (ActionListener<DriverCompletionInfo>)listener.map(profiles -> new DataNodeComputeResponse((DriverCompletionInfo)profiles, (Map<ShardId, Exception>)shardLevelFailures)));){
            ActionListener<Void> parentListener = computeListener.acquireAvoid();
            try {
                ExchangeSinkHandler externalSink = this.exchangeService.getSinkHandler(externalId);
                ExchangeSinkHandler internalSink = this.exchangeService.createSinkHandler(request.sessionId(), request.pragmas().exchangeBufferSize());
                task.addListener(() -> {
                    this.exchangeService.finishSinkHandler(externalId, (Exception)((Object)new TaskCancelledException(task.getReasonCancelled())));
                    this.exchangeService.finishSinkHandler(request.sessionId(), (Exception)((Object)new TaskCancelledException(task.getReasonCancelled())));
                });
                EsqlFlags flags = this.computeService.createFlags();
                int maxConcurrentShards = request.pragmas().maxConcurrentShardsPerNode();
                boolean sortedTimeSeriesSource = PlannerUtils.requiresSortedTimeSeriesSource(request.plan());
                if (sortedTimeSeriesSource) {
                    maxConcurrentShards = Math.clamp((long)Math.ceilDiv(request.pragmas().taskConcurrency(), 3), 1, maxConcurrentShards);
                }
                DataNodeRequestExecutor dataNodeRequestExecutor = new DataNodeRequestExecutor(flags, request, task, internalSink, maxConcurrentShards, failFastOnShardFailure, shardLevelFailures, sortedTimeSeriesSource, computeListener, searchContexts);
                dataNodeRequestExecutor.start();
                ExchangeSourceHandler exchangeSource = new ExchangeSourceHandler(1, this.esqlExecutor);
                exchangeSource.addRemoteSink((arg_0, arg_1) -> ((ExchangeSinkHandler)internalSink).fetchPageAsync(arg_0, arg_1), true, () -> {}, 1, ActionListener.noop());
                ActionListener<DriverCompletionInfo> reductionListener = computeListener.acquireCompute();
                this.computeService.runCompute(task, new ComputeContext(request.sessionId(), "node_reduce", request.clusterAlias(), flags, searchContexts, request.configuration(), new FoldContext(request.pragmas().foldLimit().getBytes()), () -> ((ExchangeSourceHandler)exchangeSource).createExchangeSource(), () -> externalSink.createExchangeSink(() -> {})), reducePlan, planTimeProfile, (ActionListener<DriverCompletionInfo>)ActionListener.wrap(resp -> externalSink.addCompletionListener(ActionListener.running(() -> {
                    this.exchangeService.finishSinkHandler(externalId, null);
                    reductionListener.onResponse(resp);
                })), e -> {
                    LOGGER.debug("Error in node-level reduction", (Throwable)e);
                    this.exchangeService.finishSinkHandler(externalId, e);
                    reductionListener.onFailure(e);
                }));
                parentListener.onResponse(null);
            }
            catch (Exception e2) {
                this.exchangeService.finishSinkHandler(externalId, e2);
                this.exchangeService.finishSinkHandler(request.sessionId(), e2);
                parentListener.onFailure(e2);
            }
        }
    }

    public void messageReceived(DataNodeRequest request, TransportChannel channel, Task task) {
        PhysicalPlan physicalPlan;
        ChannelActionListener listener = new ChannelActionListener(channel);
        Configuration configuration = request.configuration();
        PlanTimeProfile planTimeProfile = null;
        if (configuration.profile()) {
            planTimeProfile = new PlanTimeProfile();
        }
        if (!((physicalPlan = request.plan()) instanceof ExchangeSinkExec)) {
            listener.onFailure((Exception)new IllegalStateException("expected exchange sink for a remote compute; got " + String.valueOf(request.plan())));
            return;
        }
        ExchangeSinkExec plan = (ExchangeSinkExec)physicalPlan;
        ReductionPlan reductionPlan = ComputeService.reductionPlan(this.computeService.plannerSettings(), this.computeService.createFlags(), configuration, configuration.newFoldContext(), plan, request.runNodeLevelReduction(), request.reductionLateMaterialization(), planTimeProfile);
        String sessionId = request.sessionId();
        request = new DataNodeRequest(sessionId + "[n]", request.configuration(), request.clusterAlias(), request.shards(), request.aliasFilters(), request.plan(), request.indices(), request.indicesOptions(), request.runNodeLevelReduction(), request.reductionLateMaterialization());
        boolean failFastOnShardFailures = !DataNodeComputeHandler.supportShardLevelRetryFailure(channel.getVersion());
        ComputeSearchContextByShardId computeSearchContexts = new ComputeSearchContextByShardId(request.shards().size());
        this.runComputeOnDataNode((CancellableTask)task, sessionId, reductionPlan.nodeReducePlan(), request.withPlan(reductionPlan.dataNodePlan()), failFastOnShardFailures, computeSearchContexts, planTimeProfile, (ActionListener<DataNodeComputeResponse>)ActionListener.releaseAfter((ActionListener)listener, (Releasable)computeSearchContexts));
    }

    static boolean supportShardLevelRetryFailure(TransportVersion transportVersion) {
        return transportVersion.supports(ESQL_RETRY_ON_SHARD_LEVEL_FAILURE);
    }

    private class DataNodeRequestExecutor {
        private final EsqlFlags flags;
        private final DataNodeRequest request;
        private final CancellableTask parentTask;
        private final ExchangeSinkHandler exchangeSink;
        private final ComputeListener computeListener;
        private final int maxConcurrentShards;
        private final ExchangeSink blockingSink;
        private final boolean singleShardPipeline;
        private final boolean failFastOnShardFailure;
        private final Map<ShardId, Exception> shardLevelFailures;
        private final ComputeSearchContextByShardId searchContexts;
        private final PlanTimeProfile planTimeProfile;

        DataNodeRequestExecutor(EsqlFlags flags, DataNodeRequest request, CancellableTask parentTask, ExchangeSinkHandler exchangeSink, int maxConcurrentShards, boolean failFastOnShardFailure, Map<ShardId, Exception> shardLevelFailures, boolean singleShardPipeline, ComputeListener computeListener, ComputeSearchContextByShardId searchContexts) {
            this.flags = flags;
            this.request = request;
            this.parentTask = parentTask;
            this.exchangeSink = exchangeSink;
            this.computeListener = computeListener;
            this.maxConcurrentShards = maxConcurrentShards;
            this.failFastOnShardFailure = failFastOnShardFailure;
            this.shardLevelFailures = shardLevelFailures;
            this.singleShardPipeline = singleShardPipeline;
            this.blockingSink = exchangeSink.createExchangeSink(() -> {});
            this.searchContexts = searchContexts;
            this.planTimeProfile = new PlanTimeProfile();
        }

        void start() {
            this.runBatch(0);
        }

        private void runBatch(int startBatchIndex) {
            Configuration configuration = this.request.configuration();
            String clusterAlias = this.request.clusterAlias();
            String sessionId = this.request.sessionId();
            final int endBatchIndex = Math.min(startBatchIndex + this.maxConcurrentShards, this.request.shards().size());
            final AtomicInteger pagesProduced = new AtomicInteger();
            final List<DataNodeRequest.Shard> shards = this.request.shards().subList(startBatchIndex, endBatchIndex);
            ActionListener<DriverCompletionInfo> batchListener = new ActionListener<DriverCompletionInfo>(){
                final ActionListener<DriverCompletionInfo> ref;
                {
                    this.ref = DataNodeRequestExecutor.this.computeListener.acquireCompute();
                }

                public void onResponse(DriverCompletionInfo info) {
                    try {
                        DataNodeRequestExecutor.this.onBatchCompleted(endBatchIndex);
                    }
                    finally {
                        this.ref.onResponse((Object)info);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onFailure(Exception e) {
                    if (pagesProduced.get() == 0 && !DataNodeRequestExecutor.this.failFastOnShardFailure) {
                        for (DataNodeRequest.Shard shard : shards) {
                            DataNodeRequestExecutor.this.addShardLevelFailure(shard.shardId(), e);
                        }
                        this.onResponse(DriverCompletionInfo.EMPTY);
                    } else {
                        try {
                            DataNodeComputeHandler.this.exchangeService.finishSinkHandler(DataNodeRequestExecutor.this.request.sessionId(), e);
                        }
                        finally {
                            this.ref.onFailure(e);
                        }
                    }
                }
            };
            this.acquireSearchContexts(clusterAlias, shards, configuration, this.request.aliasFilters(), (ActionListener<IndexedByShardId<ComputeSearchContext>>)ActionListener.wrap(arg_0 -> this.lambda$runBatch$4((ActionListener)batchListener, sessionId, clusterAlias, configuration, pagesProduced, arg_0), arg_0 -> ((ActionListener)batchListener).onFailure(arg_0)));
        }

        private void acquireSearchContexts(String clusterAlias, List<DataNodeRequest.Shard> shards, Configuration configuration, Map<Index, AliasFilter> aliasFilters, ActionListener<IndexedByShardId<ComputeSearchContext>> listener) {
            ArrayList<Tuple> targetShards = new ArrayList<Tuple>();
            for (DataNodeRequest.Shard shard : shards) {
                try {
                    IndexShard indexShard = DataNodeComputeHandler.this.searchService.getIndicesService().indexServiceSafe(shard.shardId().getIndex()).getShard(shard.shardId().id());
                    targetShards.add(new Tuple((Object)indexShard, (Object)shard.reshardSplitShardCountSummary()));
                }
                catch (Exception e) {
                    if (this.addShardLevelFailure(shard.shardId(), e)) continue;
                    listener.onFailure(e);
                    return;
                }
            }
            ActionRunnable doAcquire = ActionRunnable.supply(listener, () -> {
                ComputeSearchContextByShardId computeSearchContextByShardId = this.searchContexts;
                synchronized (computeSearchContextByShardId) {
                    int startingIndex;
                    int endingIndex = startingIndex = this.searchContexts.length();
                    for (Tuple targetShard : targetShards) {
                        SearchContext context = null;
                        IndexShard indexShard = (IndexShard)targetShard.v1();
                        try {
                            AliasFilter aliasFilter = aliasFilters.getOrDefault(indexShard.shardId().getIndex(), AliasFilter.EMPTY);
                            ShardSearchRequest shardRequest = new ShardSearchRequest(indexShard.shardId(), configuration.absoluteStartedTimeInMillis(), aliasFilter, clusterAlias, (SplitShardCountSummary)targetShard.v2());
                            context = DataNodeComputeHandler.this.searchService.createSearchContext(shardRequest, SearchService.NO_TIMEOUT);
                            context.preProcess();
                            ComputeSearchContext cse = new ComputeSearchContext(endingIndex, context);
                            ++endingIndex;
                            this.searchContexts.add(cse);
                        }
                        catch (Exception e) {
                            if (this.addShardLevelFailure(indexShard.shardId(), e)) {
                                IOUtils.close(context);
                                continue;
                            }
                            IndexedByShardId<ComputeSearchContext> subList = this.searchContexts.subRange(startingIndex, endingIndex);
                            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{context, () -> IOUtils.close((Iterable)subList.collection())});
                            throw e;
                        }
                    }
                    return this.searchContexts.subRange(startingIndex, endingIndex);
                }
            });
            AtomicBoolean waitedForRefreshes = new AtomicBoolean();
            try (RefCountingRunnable refs = new RefCountingRunnable(() -> {
                if (waitedForRefreshes.get()) {
                    DataNodeComputeHandler.this.esqlExecutor.execute((Runnable)doAcquire);
                } else {
                    doAcquire.run();
                }
            });){
                for (Tuple targetShard : targetShards) {
                    Releasable ref = refs.acquire();
                    ((IndexShard)targetShard.v1()).ensureShardSearchActive(await -> {
                        try (Releasable releasable = ref;){
                            if (await.booleanValue()) {
                                waitedForRefreshes.set(true);
                            }
                        }
                    });
                }
            }
        }

        private void onBatchCompleted(int lastBatchIndex) {
            if (lastBatchIndex < this.request.shards().size() && !this.exchangeSink.isFinished()) {
                this.runBatch(lastBatchIndex);
            } else {
                ActionListener<Void> completionListener = this.computeListener.acquireAvoid();
                this.exchangeSink.addCompletionListener(ActionListener.runAfter(completionListener, () -> DataNodeComputeHandler.this.exchangeService.finishSinkHandler(this.request.sessionId(), null)));
                this.blockingSink.finish();
            }
        }

        private boolean addShardLevelFailure(ShardId shardId, Exception e) {
            if (this.failFastOnShardFailure) {
                return false;
            }
            this.shardLevelFailures.put(shardId, e);
            return true;
        }

        private /* synthetic */ void lambda$runBatch$4(ActionListener batchListener, String sessionId, String clusterAlias, Configuration configuration, AtomicInteger pagesProduced, IndexedByShardId acquiredSearchContexts) throws Exception {
            assert (ThreadPool.assertCurrentThreadPool((String[])new String[]{"search", "esql_worker"}));
            if (acquiredSearchContexts.isEmpty()) {
                batchListener.onResponse((Object)DriverCompletionInfo.EMPTY);
                return;
            }
            if (this.singleShardPipeline) {
                try (ComputeListener sub = new ComputeListener(DataNodeComputeHandler.this.threadPool, () -> {}, (ActionListener<DriverCompletionInfo>)batchListener);){
                    for (ComputeSearchContext searchContext : acquiredSearchContexts.collection()) {
                        ComputeContext computeContext = new ComputeContext(sessionId, "data", clusterAlias, this.flags, (IndexedByShardId<ComputeSearchContext>)new IndexedByShardIdFromSingleton((Object)searchContext, searchContext.index()), configuration, configuration.newFoldContext(), null, () -> this.exchangeSink.createExchangeSink(pagesProduced::incrementAndGet));
                        DataNodeComputeHandler.this.computeService.runCompute(this.parentTask, computeContext, this.request.plan(), this.planTimeProfile, sub.acquireCompute());
                    }
                }
            } else {
                ComputeContext computeContext = new ComputeContext(sessionId, "data", clusterAlias, this.flags, (IndexedByShardId<ComputeSearchContext>)acquiredSearchContexts, configuration, configuration.newFoldContext(), null, () -> this.exchangeSink.createExchangeSink(pagesProduced::incrementAndGet));
                DataNodeComputeHandler.this.computeService.runCompute(this.parentTask, computeContext, this.request.plan(), this.planTimeProfile, (ActionListener<DriverCompletionInfo>)batchListener);
            }
        }
    }
}

