/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.compute.EsqlRefCountingListener;
import org.elasticsearch.compute.operator.DriverCompletionInfo;
import org.elasticsearch.compute.operator.ResponseHeadersCollector;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.threadpool.ThreadPool;

final class ComputeListener
implements Releasable {
    private final DriverCompletionInfo.AtomicAccumulator completionInfoAccumulator = new DriverCompletionInfo.AtomicAccumulator();
    private final EsqlRefCountingListener refs;
    private final ResponseHeadersCollector responseHeaders;
    private final Runnable runOnFailure;

    ComputeListener(ThreadPool threadPool, Runnable runOnFailure, ActionListener<DriverCompletionInfo> delegate) {
        this.runOnFailure = runOnFailure;
        this.responseHeaders = new ResponseHeadersCollector(threadPool.getThreadContext());
        this.refs = new EsqlRefCountingListener(delegate.delegateFailure((l, ignored) -> {
            this.responseHeaders.finish();
            delegate.onResponse((Object)this.completionInfoAccumulator.finish());
        }));
    }

    ActionListener<Void> acquireAvoid() {
        ActionListener listener = ActionListener.assertAtLeastOnce((ActionListener)this.refs.acquire());
        return listener.delegateResponse((l, e) -> {
            try {
                this.runOnFailure.run();
            }
            finally {
                l.onFailure(e);
            }
        });
    }

    ActionListener<DriverCompletionInfo> acquireCompute() {
        ActionListener<Void> delegate = this.acquireAvoid();
        return ActionListener.wrap(info -> {
            this.responseHeaders.collect();
            this.completionInfoAccumulator.accumulate(info);
            delegate.onResponse(null);
        }, e -> {
            this.responseHeaders.collect();
            delegate.onFailure(e);
        });
    }

    public void close() {
        this.refs.close();
    }
}

