/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.UnaryExec;

public class ExchangeSinkExec
extends UnaryExec {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(PhysicalPlan.class, "ExchangeSinkExec", ExchangeSinkExec::new);
    private final List<Attribute> output;
    private final boolean intermediateAgg;

    public ExchangeSinkExec(Source source, List<Attribute> output, boolean intermediateAgg, PhysicalPlan child) {
        super(source, child);
        this.output = output;
        this.intermediateAgg = intermediateAgg;
    }

    private ExchangeSinkExec(StreamInput in) throws IOException {
        this(Source.readFrom((PlanStreamInput)in), in.readNamedWriteableCollectionAsList(Attribute.class), in.readBoolean(), (PhysicalPlan)in.readNamedWriteable(PhysicalPlan.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeNamedWriteableCollection(this.output());
        out.writeBoolean(this.isIntermediateAgg());
        out.writeNamedWriteable((NamedWriteable)this.child());
    }

    public String getWriteableName() {
        return ExchangeSinkExec.ENTRY.name;
    }

    @Override
    public List<Attribute> output() {
        return this.output;
    }

    public boolean isIntermediateAgg() {
        return this.intermediateAgg;
    }

    @Override
    protected NodeInfo<? extends ExchangeSinkExec> info() {
        return NodeInfo.create(this, ExchangeSinkExec::new, this.output, this.intermediateAgg, this.child());
    }

    @Override
    public ExchangeSinkExec replaceChild(PhysicalPlan newChild) {
        return new ExchangeSinkExec(this.source(), this.output, this.intermediateAgg, newChild);
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            ExchangeSinkExec that = (ExchangeSinkExec)o;
            return this.intermediateAgg == that.intermediateAgg && Objects.equals(this.output, that.output);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.output, this.intermediateAgg, this.child());
    }
}

