/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.UnaryExec;

public class ExchangeExec
extends UnaryExec {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(PhysicalPlan.class, "ExchangeExec", ExchangeExec::new);
    private final List<Attribute> output;
    private final boolean inBetweenAggs;

    public ExchangeExec(Source source, PhysicalPlan child) {
        this(source, Collections.emptyList(), false, child);
    }

    public ExchangeExec(Source source, List<Attribute> output, boolean inBetweenAggs, PhysicalPlan child) {
        super(source, child);
        this.output = output;
        this.inBetweenAggs = inBetweenAggs;
    }

    private ExchangeExec(StreamInput in) throws IOException {
        this(Source.readFrom((PlanStreamInput)in), in.readNamedWriteableCollectionAsList(Attribute.class), in.readBoolean(), (PhysicalPlan)in.readNamedWriteable(PhysicalPlan.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeNamedWriteableCollection(this.output);
        out.writeBoolean(this.inBetweenAggs());
        out.writeNamedWriteable((NamedWriteable)this.child());
    }

    public String getWriteableName() {
        return ExchangeExec.ENTRY.name;
    }

    @Override
    public List<Attribute> output() {
        return this.output.isEmpty() ? super.output() : this.output;
    }

    public boolean inBetweenAggs() {
        return this.inBetweenAggs;
    }

    @Override
    protected AttributeSet computeReferences() {
        return AttributeSet.EMPTY;
    }

    @Override
    public UnaryExec replaceChild(PhysicalPlan newChild) {
        return new ExchangeExec(this.source(), this.output, this.inBetweenAggs, newChild);
    }

    @Override
    protected NodeInfo<? extends PhysicalPlan> info() {
        return NodeInfo.create(this, ExchangeExec::new, this.output, this.inBetweenAggs, this.child());
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ExchangeExec other = (ExchangeExec)obj;
        return this.output.equals(other.output) && this.inBetweenAggs == other.inBetweenAggs;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.output, this.inBetweenAggs);
    }
}

