/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.util.List;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;

public interface EstimatesRowSize {
    public static PhysicalPlan estimateRowSize(int extraRowSize, PhysicalPlan plan) {
        State state = new State();
        state.maxEstimatedRowSize = state.estimatedRowSize = extraRowSize;
        return plan.transformDown(exec -> {
            if (exec instanceof EstimatesRowSize) {
                EstimatesRowSize r = (EstimatesRowSize)((Object)exec);
                return r.estimateRowSize(state);
            }
            return exec;
        });
    }

    public PhysicalPlan estimateRowSize(State var1);

    public static int estimateSize(DataType dataType) {
        ElementType elementType = PlannerUtils.toElementType(dataType);
        if (elementType == ElementType.UNKNOWN) {
            throw new EsqlIllegalArgumentException("[unknown] can't be the result of field extraction");
        }
        return dataType.estimatedSize();
    }

    public static final class State {
        private int estimatedRowSize;
        private int maxEstimatedRowSize;
        private boolean needsSortedDocIds;

        public void add(boolean needsSortedDocIds, int bytes) {
            this.estimatedRowSize += bytes;
            this.maxEstimatedRowSize = Math.max(this.estimatedRowSize, this.maxEstimatedRowSize);
            this.needsSortedDocIds |= needsSortedDocIds;
        }

        public void add(boolean needsSortedDocIds, List<? extends Expression> expressions) {
            expressions.stream().forEach(a -> this.estimatedRowSize += EstimatesRowSize.estimateSize(a.dataType()));
            this.maxEstimatedRowSize = Math.max(this.estimatedRowSize, this.maxEstimatedRowSize);
            this.needsSortedDocIds |= needsSortedDocIds;
        }

        public int consumeAllFields(boolean producesUnsortedDocIds) {
            int size = this.maxEstimatedRowSize;
            if (producesUnsortedDocIds && this.needsSortedDocIds) {
                size += 8;
            }
            this.maxEstimatedRowSize = 0;
            this.estimatedRowSize = 0;
            this.needsSortedDocIds = false;
            return size;
        }

        public String toString() {
            return "State{estimatedRowSize=" + this.estimatedRowSize + ", maxEstimatedRowSize=" + this.maxEstimatedRowSize + ", needsSortedDocIds=" + this.needsSortedDocIds + "}";
        }
    }
}

