/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.NodeUtils;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.physical.LeafExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;

public class EsSourceExec
extends LeafExec {
    private static final TransportVersion REMOVE_NAME_WITH_MODS = TransportVersion.fromName((String)"esql_es_source_remove_name_with_mods");
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(PhysicalPlan.class, "EsSourceExec", EsSourceExec::readFrom);
    private final String indexPattern;
    private final IndexMode indexMode;
    private final List<Attribute> attributes;
    private final QueryBuilder query;

    public EsSourceExec(EsRelation relation) {
        this(relation.source(), relation.indexPattern(), relation.indexMode(), relation.output(), null);
    }

    public EsSourceExec(Source source, String indexPattern, IndexMode indexMode, List<Attribute> attributes, QueryBuilder query) {
        super(source);
        this.indexPattern = indexPattern;
        this.indexMode = indexMode;
        this.attributes = attributes;
        this.query = query;
    }

    private static EsSourceExec readFrom(StreamInput in) throws IOException {
        Source source = Source.readFrom((PlanStreamInput)in);
        String indexPattern = in.readString();
        if (!in.getTransportVersion().supports(REMOVE_NAME_WITH_MODS)) {
            in.readMap(IndexMode::readFrom);
        }
        List attributes = in.readNamedWriteableCollectionAsList(Attribute.class);
        QueryBuilder query = (QueryBuilder)in.readOptionalNamedWriteable(QueryBuilder.class);
        IndexMode indexMode = IndexMode.fromString((String)in.readString());
        return new EsSourceExec(source, indexPattern, indexMode, attributes, query);
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeString(this.indexPattern);
        if (!out.getTransportVersion().supports(REMOVE_NAME_WITH_MODS)) {
            out.writeMap(Map.of(), (o, v) -> IndexMode.writeTo((IndexMode)v, (StreamOutput)out));
        }
        out.writeNamedWriteableCollection(this.output());
        out.writeOptionalNamedWriteable((NamedWriteable)this.query());
        out.writeString(this.indexMode().getName());
    }

    public String getWriteableName() {
        return EsSourceExec.ENTRY.name;
    }

    public String indexPattern() {
        return this.indexPattern;
    }

    public IndexMode indexMode() {
        return this.indexMode;
    }

    public QueryBuilder query() {
        return this.query;
    }

    @Override
    public List<Attribute> output() {
        return this.attributes;
    }

    @Override
    protected NodeInfo<? extends PhysicalPlan> info() {
        return NodeInfo.create(this, EsSourceExec::new, this.indexPattern, this.indexMode, this.attributes, this.query);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.indexPattern, this.indexMode, this.attributes, this.query);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EsSourceExec other = (EsSourceExec)obj;
        return Objects.equals(this.indexPattern, other.indexPattern) && Objects.equals(this.indexMode, other.indexMode) && Objects.equals(this.attributes, other.attributes) && Objects.equals(this.query, other.query);
    }

    @Override
    public String nodeString() {
        return this.nodeName() + "[" + this.indexPattern + "]" + NodeUtils.limitedToString(this.attributes);
    }
}

