/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.promql.operator;

import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;

public class VectorMatch {
    public static final VectorMatch NONE = new VectorMatch(Filter.NONE, Collections.emptySet(), Joining.NONE, Collections.emptySet());
    private final Filter filter;
    private final Set<String> filterLabels;
    private final Joining joining;
    private final Set<String> groupingLabels;

    public VectorMatch(Filter filter, Set<String> filterLabels, Joining joining, Set<String> groupingLabels) {
        this.filter = filter;
        this.filterLabels = filterLabels;
        this.joining = joining;
        this.groupingLabels = groupingLabels;
    }

    public Filter filter() {
        return this.filter;
    }

    public Set<String> filterLabels() {
        return this.filterLabels;
    }

    public Joining grouping() {
        return this.joining;
    }

    public Set<String> groupingLabels() {
        return this.groupingLabels;
    }

    public boolean equals(Object o) {
        if (super.equals(o)) {
            VectorMatch that = (VectorMatch)o;
            return this.filter == that.filter && Objects.equals(this.filterLabels, that.filterLabels) && this.joining == that.joining && Objects.equals(this.groupingLabels, that.groupingLabels);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.filter, this.filterLabels, this.joining, this.groupingLabels});
    }

    public String toString() {
        String filterString;
        String string = filterString = this.filter != Filter.NONE ? this.filter.name().toLowerCase(Locale.ROOT) + "(" + String.valueOf(this.filterLabels) + ")" : "";
        String groupingString = this.joining != Joining.NONE ? " " + this.joining.name().toLowerCase(Locale.ROOT) + (String)(!this.groupingLabels.isEmpty() ? "(" + String.valueOf(this.groupingLabels) + ")" : "") + " " : "";
        return filterString + groupingString;
    }

    public static enum Filter {
        IGNORING,
        ON,
        NONE;

    }

    public static enum Joining {
        LEFT,
        RIGHT,
        NONE;

    }
}

