/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.local;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.logical.local.EsqlProject;

public class ResolvingProject
extends EsqlProject {
    private final Function<List<Attribute>, List<? extends NamedExpression>> resolver;

    public ResolvingProject(Source source, LogicalPlan child, Function<List<Attribute>, List<? extends NamedExpression>> resolver) {
        this(source, child, resolver.apply(child.output()), resolver);
    }

    private ResolvingProject(Source source, LogicalPlan child, List<? extends NamedExpression> projections, Function<List<Attribute>, List<? extends NamedExpression>> resolver) {
        super(source, child, projections);
        this.resolver = resolver;
    }

    @Override
    public String getWriteableName() {
        throw new UnsupportedOperationException("doesn't escape the node");
    }

    public Function<List<Attribute>, List<? extends NamedExpression>> resolver() {
        return this.resolver;
    }

    @Override
    protected NodeInfo<Project> info() {
        return NodeInfo.create(this, (source, child, projections) -> new ResolvingProject(source, (LogicalPlan)child, (List<? extends NamedExpression>)projections, this.resolver), this.child(), this.projections());
    }

    @Override
    public ResolvingProject replaceChild(LogicalPlan newChild) {
        return new ResolvingProject(this.source(), newChild, this.resolver);
    }

    @Override
    public Project withProjections(List<? extends NamedExpression> projections) {
        return new ResolvingProject(this.source(), this.child(), projections, this.resolver);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.resolver);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ResolvingProject other = (ResolvingProject)obj;
        return super.equals(obj) && Objects.equals(this.resolver, other.resolver);
    }

    public EsqlProject asEsqlProject() {
        return new EsqlProject(this.source(), this.child(), this.projections());
    }
}

