/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.fuse;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.capabilities.PostAnalysisVerificationAware;
import org.elasticsearch.xpack.esql.capabilities.TelemetryAware;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.MapExpression;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.plan.logical.ExecutesOn;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;

public class Fuse
extends UnaryPlan
implements TelemetryAware,
PostAnalysisVerificationAware,
ExecutesOn.Coordinator {
    private final Attribute score;
    private final Attribute discriminator;
    private final List<NamedExpression> keys;
    private final FuseType fuseType;
    private final MapExpression options;

    public Fuse(Source source, LogicalPlan child, Attribute score, Attribute discriminator, List<NamedExpression> keys, FuseType fuseType, MapExpression options) {
        super(source, child);
        this.score = score;
        this.discriminator = discriminator;
        this.keys = keys;
        this.fuseType = fuseType;
        this.options = options;
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException("not serialized");
    }

    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("not serialized");
    }

    @Override
    protected NodeInfo<? extends LogicalPlan> info() {
        return NodeInfo.create(this, Fuse::new, this.child(), this.score, this.discriminator, this.keys, this.fuseType, this.options);
    }

    @Override
    public UnaryPlan replaceChild(LogicalPlan newChild) {
        return new Fuse(this.source(), newChild, this.score, this.discriminator, this.keys, this.fuseType, this.options);
    }

    public List<NamedExpression> keys() {
        return this.keys;
    }

    public Attribute discriminator() {
        return this.discriminator;
    }

    public Attribute score() {
        return this.score;
    }

    public FuseType fuseType() {
        return this.fuseType;
    }

    public MapExpression options() {
        return this.options;
    }

    @Override
    public boolean expressionsResolved() {
        return this.score.resolved() && this.discriminator.resolved() && this.keys.stream().allMatch(Expression::resolved);
    }

    @Override
    public void postAnalysisVerification(Failures failures) {
        if (this.score.dataType() != DataType.DOUBLE) {
            failures.add(Failure.fail(this.score, "expected SCORE BY column [{}] to be DOUBLE, not {}", new Object[]{this.score.name(), this.score.dataType()}));
        }
        if (!DataType.isString(this.discriminator.dataType())) {
            failures.add(Failure.fail(this.discriminator, "expected GROUP BY field [{}] to be KEYWORD or TEXT, not {}", new Object[]{this.discriminator.name(), this.discriminator.dataType()}));
        }
        for (NamedExpression grouping : this.keys) {
            if (DataType.isString(grouping.dataType())) continue;
            failures.add(Failure.fail(grouping, "expected KEY BY field [{}] to be KEYWORD or TEXT, not {}", new Object[]{grouping.name(), grouping.dataType()}));
        }
    }

    public static enum FuseType {
        RRF,
        LINEAR;

    }
}

