/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.capabilities.Resolvables;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.Order;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.ExecutesOn;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.PipelineBreaker;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;

public class TopN
extends UnaryPlan
implements PipelineBreaker,
ExecutesOn {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(LogicalPlan.class, "TopN", TopN::new);
    private final List<Order> order;
    private final Expression limit;
    private final transient boolean local;

    public TopN(Source source, LogicalPlan child, List<Order> order, Expression limit, boolean local) {
        super(source, child);
        this.order = order;
        this.limit = limit;
        this.local = local;
    }

    private TopN(StreamInput in) throws IOException {
        this(Source.readFrom((PlanStreamInput)in), (LogicalPlan)in.readNamedWriteable(LogicalPlan.class), in.readCollectionAsList(Order::new), (Expression)in.readNamedWriteable(Expression.class), false);
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.child());
        out.writeCollection(this.order);
        out.writeNamedWriteable((NamedWriteable)this.limit);
    }

    public String getWriteableName() {
        return TopN.ENTRY.name;
    }

    @Override
    public boolean expressionsResolved() {
        return this.limit.resolved() && Resolvables.resolved(this.order);
    }

    @Override
    protected NodeInfo<TopN> info() {
        return NodeInfo.create(this, TopN::new, this.child(), this.order, this.limit, this.local);
    }

    @Override
    public TopN replaceChild(LogicalPlan newChild) {
        return new TopN(this.source(), newChild, this.order, this.limit, this.local);
    }

    public TopN withLocal(boolean local) {
        return new TopN(this.source(), this.child(), this.order, this.limit, local);
    }

    public boolean local() {
        return this.local;
    }

    public Expression limit() {
        return this.limit;
    }

    public List<Order> order() {
        return this.order;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.order, this.limit, this.local);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            TopN other = (TopN)obj;
            return Objects.equals(this.order, other.order) && Objects.equals(this.limit, other.limit) && this.local == other.local;
        }
        return false;
    }

    @Override
    public ExecutesOn.ExecuteLocation executesOn() {
        return this.local ? ExecutesOn.ExecuteLocation.ANY : ExecutesOn.ExecuteLocation.COORDINATOR;
    }
}

