/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import org.elasticsearch.index.IndexMode;

public enum SourceCommand {
    FROM(IndexMode.STANDARD),
    TS(IndexMode.TIME_SERIES),
    PROMQL(IndexMode.TIME_SERIES);

    private final IndexMode indexMode;

    private SourceCommand(IndexMode indexMode) {
        this.indexMode = indexMode;
    }

    public static boolean isSourceCommand(String command) {
        for (SourceCommand cmd : SourceCommand.values()) {
            if (!cmd.name().equalsIgnoreCase(command)) continue;
            return true;
        }
        return false;
    }

    public IndexMode indexMode() {
        return this.indexMode;
    }
}

