/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.capabilities.PostAnalysisVerificationAware;
import org.elasticsearch.xpack.esql.capabilities.TelemetryAware;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.capabilities.Resolvables;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.plan.logical.LeafPlan;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;

public class Row
extends LeafPlan
implements PostAnalysisVerificationAware,
TelemetryAware {
    private final List<Alias> fields;

    public Row(Source source, List<Alias> fields) {
        super(source);
        this.fields = fields;
    }

    public void writeTo(StreamOutput out) {
        throw new UnsupportedOperationException("not serialized");
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException("not serialized");
    }

    public List<Alias> fields() {
        return this.fields;
    }

    @Override
    public List<Attribute> output() {
        return Expressions.asAttributes(this.fields);
    }

    @Override
    public boolean expressionsResolved() {
        return Resolvables.resolved(this.fields);
    }

    @Override
    protected NodeInfo<? extends LogicalPlan> info() {
        return NodeInfo.create(this, Row::new, this.fields);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Row constant = (Row)o;
        return Objects.equals(this.fields, constant.fields);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fields);
    }

    @Override
    public void postAnalysisVerification(Failures failures) {
        this.fields.forEach(a -> {
            if (!DataType.isRepresentable(a.dataType())) {
                failures.add(Failure.fail(a.child(), "cannot use [{}] directly in a row assignment", a.child().sourceText()));
            }
        });
    }
}

