/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.analysis.Analyzer;
import org.elasticsearch.xpack.esql.capabilities.TelemetryAware;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.UnsupportedAttribute;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.SortAgnostic;
import org.elasticsearch.xpack.esql.plan.logical.Streaming;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;

public class Rename
extends UnaryPlan
implements TelemetryAware,
Streaming,
SortAgnostic {
    private final List<Alias> renamings;

    public Rename(Source source, LogicalPlan child, List<Alias> renamings) {
        super(source, child);
        this.renamings = renamings;
    }

    public void writeTo(StreamOutput out) {
        throw new UnsupportedOperationException("not serialized");
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException("not serialized");
    }

    public List<Alias> renamings() {
        return this.renamings;
    }

    @Override
    public List<Attribute> output() {
        List<NamedExpression> projectionsAfterResolution = Analyzer.ResolveRefs.projectionsForRename(this, new ArrayList<Attribute>(this.child().output()), null);
        return Expressions.asAttributes(projectionsAfterResolution);
    }

    @Override
    public boolean expressionsResolved() {
        for (Alias alias : this.renamings) {
            if (alias.resolved() || alias.child() instanceof UnsupportedAttribute) continue;
            return false;
        }
        return true;
    }

    @Override
    public UnaryPlan replaceChild(LogicalPlan newChild) {
        return new Rename(this.source(), newChild, this.renamings);
    }

    @Override
    protected NodeInfo<? extends LogicalPlan> info() {
        return NodeInfo.create(this, Rename::new, this.child(), this.renamings);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.renamings);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return Objects.equals(this.renamings, ((Rename)obj).renamings);
    }
}

