/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.capabilities.PostAnalysisVerificationAware;
import org.elasticsearch.xpack.esql.capabilities.TelemetryAware;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.capabilities.Resolvables;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeMap;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.NameId;
import org.elasticsearch.xpack.esql.core.expression.ReferenceAttribute;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.NamedExpressions;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.GeneratingPlan;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.SortAgnostic;
import org.elasticsearch.xpack.esql.plan.logical.SortPreserving;
import org.elasticsearch.xpack.esql.plan.logical.Streaming;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;

public class Eval
extends UnaryPlan
implements GeneratingPlan<Eval>,
PostAnalysisVerificationAware,
TelemetryAware,
Streaming,
SortAgnostic,
SortPreserving {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(LogicalPlan.class, "Eval", Eval::new);
    private final List<Alias> fields;
    private List<Attribute> lazyOutput;

    public Eval(Source source, LogicalPlan child, List<Alias> fields) {
        super(source, child);
        this.fields = fields;
    }

    private Eval(StreamInput in) throws IOException {
        this(Source.readFrom((PlanStreamInput)in), (LogicalPlan)in.readNamedWriteable(LogicalPlan.class), in.readCollectionAsList(Alias::new));
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.child());
        out.writeCollection(this.fields());
    }

    public String getWriteableName() {
        return Eval.ENTRY.name;
    }

    public List<Alias> fields() {
        return this.fields;
    }

    @Override
    public List<Attribute> output() {
        if (this.lazyOutput == null) {
            this.lazyOutput = NamedExpressions.mergeOutputAttributes(this.fields, this.child().output());
        }
        return this.lazyOutput;
    }

    @Override
    protected AttributeSet computeReferences() {
        return Eval.computeReferences(this.fields);
    }

    public static AttributeSet computeReferences(List<Alias> fields) {
        AttributeSet generated = AttributeSet.of(Expressions.asAttributes(fields));
        return Expressions.references(fields).subtract(generated);
    }

    @Override
    public List<Attribute> generatedAttributes() {
        return Expressions.asAttributes(this.fields);
    }

    @Override
    public Eval withGeneratedNames(List<String> newNames) {
        this.checkNumberOfNewNames(newNames);
        return new Eval(this.source(), this.child(), this.renameAliases(this.fields, newNames));
    }

    private List<Alias> renameAliases(List<Alias> originalAttributes, List<String> newNames) {
        AttributeMap.Builder<Attribute> aliasReplacedByBuilder = AttributeMap.builder();
        ArrayList<Alias> newFields = new ArrayList<Alias>(originalAttributes.size());
        for (int i = 0; i < originalAttributes.size(); ++i) {
            Alias field = originalAttributes.get(i);
            String newName = newNames.get(i);
            if (field.name().equals(newName)) {
                newFields.add(field);
                continue;
            }
            Alias newField = new Alias(field.source(), newName, field.child(), new NameId(), field.synthetic());
            newFields.add(newField);
            aliasReplacedByBuilder.put(field.toAttribute(), newField.toAttribute());
        }
        AttributeMap aliasReplacedBy = aliasReplacedByBuilder.build();
        ArrayList<Alias> newFieldsWithUpdatedRefs = new ArrayList<Alias>(originalAttributes.size());
        for (Alias newField : newFields) {
            newFieldsWithUpdatedRefs.add((Alias)newField.transformUp(ReferenceAttribute.class, (E r) -> aliasReplacedBy.resolve(r, r)));
        }
        return newFieldsWithUpdatedRefs;
    }

    @Override
    public boolean expressionsResolved() {
        return Resolvables.resolved(this.fields);
    }

    @Override
    public UnaryPlan replaceChild(LogicalPlan newChild) {
        return new Eval(this.source(), newChild, this.fields);
    }

    @Override
    protected NodeInfo<? extends LogicalPlan> info() {
        return NodeInfo.create(this, Eval::new, this.child(), this.fields);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Eval eval = (Eval)o;
        return this.child().equals(eval.child()) && Objects.equals(this.fields, eval.fields);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fields);
    }

    @Override
    public void postAnalysisVerification(Failures failures) {
        this.fields.forEach(field -> {
            DataType dataType = field.dataType();
            if (!DataType.isRepresentable(dataType)) {
                failures.add(Failure.fail(field, "EVAL does not support type [{}] as the return data type of expression [{}]", dataType.typeName(), field.child().sourceText()));
            }
        });
    }
}

