/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.esql.action.EsqlCapabilities;
import org.elasticsearch.xpack.esql.analysis.UnmappedResolution;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.Foldables;
import org.elasticsearch.xpack.esql.parser.ParsingException;
import org.elasticsearch.xpack.esql.plan.EsqlStatement;
import org.elasticsearch.xpack.esql.plan.QuerySetting;
import org.elasticsearch.xpack.esql.plan.SettingsValidationContext;

public class QuerySettings {
    public static final QuerySettingDef<String> PROJECT_ROUTING = new QuerySettingDef<Object>("project_routing", DataType.KEYWORD, true, true, false, "A project routing expression, used to define which projects to route the query to. Only supported if Cross-Project Search is enabled.", (value, ctx) -> ctx.crossProjectEnabled() ? null : "cross-project search not enabled", value -> Foldables.stringLiteralValueOf(value, "Unexpected value"), null);
    public static final QuerySettingDef<ZoneId> TIME_ZONE = new QuerySettingDef<ZoneOffset>("time_zone", DataType.KEYWORD, false, true, true, "The default timezone to be used in the query, by the functions and commands that require it. Defaults to UTC", value -> {
        String timeZone = Foldables.stringLiteralValueOf(value, "Unexpected value");
        try {
            return ZoneId.of(timeZone);
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Invalid time zone [" + timeZone + "]");
        }
    }, ZoneOffset.UTC);
    public static final QuerySettingDef<UnmappedResolution> UNMAPPED_FIELDS = new QuerySettingDef<UnmappedResolution>("unmapped_fields", DataType.KEYWORD, false, true, false, "Defines how unmapped fields are treated. Possible values are: \"FAIL\" (default) - fails the query if unmapped fields are present; \"NULLIFY\" - treats unmapped fields as null values. ", value -> {
        String resolution = Foldables.stringLiteralValueOf(value, "Unexpected value");
        try {
            UnmappedResolution res = UnmappedResolution.valueOf(resolution.toUpperCase(Locale.ROOT));
            if (res == UnmappedResolution.LOAD && !EsqlCapabilities.Cap.OPTIONAL_FIELDS.isEnabled()) {
                throw new IllegalArgumentException("'LOAD' is only supported in snapshot builds");
            }
            return res;
        }
        catch (Exception exc) {
            UnmappedResolution[] values = EsqlCapabilities.Cap.OPTIONAL_FIELDS.isEnabled() ? UnmappedResolution.values() : Arrays.stream(UnmappedResolution.values()).filter(e -> e != UnmappedResolution.LOAD).toArray();
            throw new IllegalArgumentException("Invalid unmapped_fields resolution [" + String.valueOf(value) + "], must be one of " + Arrays.toString((Object[])values));
        }
    }, UnmappedResolution.FAIL);
    public static final Map<String, QuerySettingDef<?>> SETTINGS_BY_NAME = Stream.of(UNMAPPED_FIELDS, PROJECT_ROUTING, TIME_ZONE).collect(Collectors.toMap(QuerySettingDef::name, Function.identity()));

    public static void validate(EsqlStatement statement, SettingsValidationContext ctx) {
        for (QuerySetting setting : statement.settings()) {
            Literal l;
            QuerySettingDef<?> def = SETTINGS_BY_NAME.get(setting.name());
            if (def == null) {
                throw new ParsingException(setting.source(), "Unknown setting [" + setting.name() + "]", new Object[0]);
            }
            if (def.snapshotOnly && !ctx.isSnapshot()) {
                throw new ParsingException(setting.source(), "Setting [" + setting.name() + "] is only available in snapshot builds", new Object[0]);
            }
            if (setting.value().dataType() != def.type()) {
                throw new ParsingException(setting.source(), "Setting [" + setting.name() + "] must be of type " + String.valueOf((Object)def.type()), new Object[0]);
            }
            Expression expression = setting.value();
            if (!(expression instanceof Literal)) {
                throw new ParsingException(setting.source(), "Setting [" + setting.name() + "] must have a literal value", new Object[0]);
            }
            Literal literal = l = (Literal)expression;
            String error = def.validator().validate(literal, ctx);
            if (error == null) continue;
            throw new ParsingException("Error validating setting [" + setting.name() + "]: " + error, new Object[0]);
        }
    }

    public record QuerySettingDef<T>(String name, DataType type, boolean serverlessOnly, boolean preview, boolean snapshotOnly, String description, Validator validator, Parser<T> parser, T defaultValue) {
        public QuerySettingDef(String name, DataType type, boolean serverlessOnly, boolean preview, boolean snapshotOnly, String description, Parser<T> parser, T defaultValue) {
            this(name, type, serverlessOnly, preview, snapshotOnly, description, (value, rcs) -> {
                try {
                    parser.parse(value);
                    return null;
                }
                catch (Exception exc) {
                    return exc.getMessage();
                }
            }, parser, defaultValue);
        }

        public T parse(@Nullable Literal value) {
            if (value == null) {
                return this.defaultValue;
            }
            return this.parser.parse(value);
        }

        @FunctionalInterface
        public static interface Validator {
            @Nullable
            public String validate(Literal var1, SettingsValidationContext var2);
        }

        @FunctionalInterface
        public static interface Parser<T> {
            public T parse(Literal var1);
        }
    }
}

