/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan;

import java.util.List;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.plan.QuerySetting;
import org.elasticsearch.xpack.esql.plan.QuerySettings;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;

public record EsqlStatement(LogicalPlan plan, List<QuerySetting> settings) {
    public <T> T setting(QuerySettings.QuerySettingDef<T> settingDef) {
        return this.settingOrDefault(settingDef, settingDef.defaultValue());
    }

    public <T> T settingOrDefault(QuerySettings.QuerySettingDef<T> settingDef, T defaultValue) {
        Expression expression = this.setting(settingDef.name());
        if (expression == null) {
            return defaultValue;
        }
        return settingDef.parse((Literal)expression);
    }

    public Expression setting(String name) {
        if (this.settings == null) {
            return null;
        }
        Expression expression = null;
        for (QuerySetting setting : this.settings) {
            if (!setting.name().equals(name)) continue;
            expression = setting.value();
        }
        return expression;
    }

    @Override
    public String toString() {
        return "EsqlStatement{plan=" + String.valueOf(this.plan) + ", settings=" + String.valueOf(this.settings) + "}";
    }
}

