/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.parser;

import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.Lexer;
import org.elasticsearch.xpack.esql.parser.EsqlConfig;
import org.elasticsearch.xpack.esql.parser.ParsingException;

public abstract class LexerConfig
extends Lexer {
    EsqlConfig config;
    private int promqlDepth = 0;

    public LexerConfig() {
    }

    public LexerConfig(CharStream input) {
        super(input);
    }

    boolean isDevVersion() {
        return this.config == null || this.config.isDevVersion();
    }

    void setEsqlConfig(EsqlConfig config) {
        this.config = config;
    }

    void incPromqlDepth() {
        ++this.promqlDepth;
    }

    void decPromqlDepth() {
        if (this.promqlDepth == 0) {
            throw new ParsingException("Invalid PromQL command, unexpected '('", new Object[0]);
        }
        --this.promqlDepth;
    }

    void resetPromqlDepth() {
        if (this.promqlDepth != 0) {
            throw new ParsingException("Invalid PromQL declaration, missing [{}] [{}] parenthesis", Math.absExact(this.promqlDepth), Character.valueOf(this.promqlDepth > 0 ? (char)'(' : ')'));
        }
    }

    boolean isPromqlQuery() {
        return this.promqlDepth > 0;
    }
}

