/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.physical.local;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.xpack.esql.capabilities.TranslationAware;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeMap;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.util.Queries;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Count;
import org.elasticsearch.xpack.esql.optimizer.LocalPhysicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.PhysicalOptimizerRules;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushdownPredicates;
import org.elasticsearch.xpack.esql.plan.physical.AggregateExec;
import org.elasticsearch.xpack.esql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.EsStatsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.planner.AbstractPhysicalOperationProviders;
import org.elasticsearch.xpack.esql.planner.TranslatorHandler;

public class PushStatsToSource
extends PhysicalOptimizerRules.ParameterizedOptimizerRule<AggregateExec, LocalPhysicalOptimizerContext> {
    @Override
    protected PhysicalPlan rule(AggregateExec aggregateExec, LocalPhysicalOptimizerContext context) {
        PhysicalPlan plan = aggregateExec;
        PhysicalPlan physicalPlan = aggregateExec.child();
        if (physicalPlan instanceof EsQueryExec) {
            EsQueryExec queryExec = (EsQueryExec)physicalPlan;
            Tuple<List<Attribute>, List<EsStatsQueryExec.Stat>> tuple = this.pushableStats(aggregateExec, context);
            List stats = (List)tuple.v2();
            if (stats.size() != 1 || stats.size() != aggregateExec.aggregates().size()) {
                return aggregateExec;
            }
            plan = new EsStatsQueryExec(aggregateExec.source(), queryExec.indexPattern(), queryExec.query(), queryExec.limit(), (List)tuple.v1(), (EsStatsQueryExec.Stat)stats.get(0));
        }
        return plan;
    }

    private Tuple<List<Attribute>, List<EsStatsQueryExec.Stat>> pushableStats(AggregateExec aggregate, LocalPhysicalOptimizerContext context) {
        AttributeMap.Builder<EsStatsQueryExec.Stat> statsBuilder = AttributeMap.builder();
        Tuple tuple = new Tuple(new ArrayList(), new ArrayList());
        if (aggregate.groupings().isEmpty()) {
            for (NamedExpression namedExpression : aggregate.aggregates()) {
                Attribute attribute = namedExpression.toAttribute();
                EsStatsQueryExec.Stat stat = statsBuilder.computeIfAbsent(attribute, a -> {
                    Alias as;
                    Expression child;
                    if (agg instanceof Alias && (child = (as = (Alias)agg).child()) instanceof Count) {
                        Count count = (Count)child;
                        Expression target = count.field();
                        String fieldName = null;
                        ExistsQueryBuilder query = null;
                        if (target.foldable()) {
                            fieldName = "*";
                        } else if (target instanceof FieldAttribute) {
                            FieldAttribute fa = (FieldAttribute)target;
                            FieldAttribute.FieldName fName = fa.fieldName();
                            if (context.searchStats().isSingleValue(fName)) {
                                fieldName = fName.string();
                                query = QueryBuilders.existsQuery((String)fieldName);
                            }
                        }
                        if (fieldName != null) {
                            if (count.hasFilter()) {
                                if (TranslationAware.translatable(count.filter(), LucenePushdownPredicates.DEFAULT) != TranslationAware.Translatable.YES) {
                                    return null;
                                }
                                Query countFilter = TranslatorHandler.TRANSLATOR_HANDLER.asQuery(LucenePushdownPredicates.DEFAULT, count.filter());
                                query = Queries.combine(Queries.Clause.MUST, Arrays.asList(countFilter.toQueryBuilder(), query));
                            }
                            return new EsStatsQueryExec.BasicStat(fieldName, EsStatsQueryExec.StatsType.COUNT, (QueryBuilder)query);
                        }
                    }
                    return null;
                });
                if (stat == null) continue;
                List<Attribute> intermediateAttributes = AbstractPhysicalOperationProviders.intermediateAttributes(Collections.singletonList(namedExpression), Collections.emptyList());
                ((List)tuple.v1()).addAll(intermediateAttributes);
                ((List)tuple.v2()).add(stat);
            }
        }
        return tuple;
    }
}

