/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical.promql;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;

public final class AutomatonUtils {
    private static final int MAX_IN_VALUES = 256;
    private static final int MAX_PATTERN_LENGTH = 1000;

    private AutomatonUtils() {
    }

    public static boolean matchesAll(Automaton automaton) {
        return Operations.isTotal((Automaton)automaton);
    }

    public static boolean matchesNone(Automaton automaton) {
        return Operations.isEmpty((Automaton)automaton);
    }

    public static boolean matchesEmpty(Automaton automaton) {
        return Operations.run((Automaton)automaton, (String)"");
    }

    public static String matchesExact(Automaton automaton) {
        if (automaton.getNumStates() == 0) {
            return null;
        }
        IntsRef singleton = Operations.getSingleton((Automaton)automaton);
        if (singleton == null) {
            return null;
        }
        return UnicodeUtil.newString((int[])singleton.ints, (int)singleton.offset, (int)singleton.length);
    }

    private static boolean isLiteral(String s) {
        if (s == null || s.isEmpty()) {
            return true;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    return false;
                }
            }
        }
        return true;
    }

    private static String removeStartingAnchor(String normalized) {
        return normalized.startsWith("^") ? normalized.substring(1) : normalized;
    }

    private static String removeEndingAnchor(String normalized) {
        return normalized.endsWith("$") ? normalized.substring(0, normalized.length() - 1) : normalized;
    }

    private static PatternFragment classifyPart(String part) {
        boolean endsWithWildcard;
        String trimmed = AutomatonUtils.removeStartingAnchor(AutomatonUtils.removeEndingAnchor(part.trim()));
        if (trimmed.isEmpty()) {
            return new PatternFragment(PatternFragment.Type.EXACT, "");
        }
        boolean startsWithWildcard = trimmed.startsWith(".*") || trimmed.startsWith(".+");
        boolean bl = endsWithWildcard = trimmed.endsWith(".*") || trimmed.endsWith(".+");
        if (startsWithWildcard && endsWithWildcard) {
            return new PatternFragment(PatternFragment.Type.REGEX, part.trim());
        }
        if (startsWithWildcard) {
            String suffix = trimmed.substring(2);
            if (AutomatonUtils.isLiteral(suffix)) {
                return new PatternFragment(trimmed.startsWith(".*") ? PatternFragment.Type.SUFFIX : PatternFragment.Type.PROPER_SUFFIX, suffix);
            }
            return new PatternFragment(PatternFragment.Type.REGEX, part.trim());
        }
        if (endsWithWildcard) {
            String prefix = trimmed.substring(0, trimmed.length() - 2);
            if (AutomatonUtils.isLiteral(prefix)) {
                return new PatternFragment(trimmed.endsWith(".*") ? PatternFragment.Type.PREFIX : PatternFragment.Type.PROPER_PREFIX, prefix);
            }
            return new PatternFragment(PatternFragment.Type.REGEX, part.trim());
        }
        if (AutomatonUtils.isLiteral(trimmed)) {
            return new PatternFragment(PatternFragment.Type.EXACT, trimmed);
        }
        return new PatternFragment(PatternFragment.Type.REGEX, part.trim());
    }

    public static List<PatternFragment> extractFragments(String pattern) {
        if (pattern == null || pattern.length() > 1000) {
            return null;
        }
        String normalized = pattern;
        normalized = AutomatonUtils.removeStartingAnchor(normalized);
        if ((normalized = AutomatonUtils.removeEndingAnchor(normalized)).contains("(") || normalized.contains(")")) {
            return null;
        }
        if (normalized.contains("\\|")) {
            return null;
        }
        String[] parts = normalized.split("\\|");
        if (parts.length > 256) {
            return null;
        }
        ArrayList<PatternFragment> fragments = new ArrayList<PatternFragment>(parts.length);
        for (String part : parts) {
            PatternFragment fragment = AutomatonUtils.classifyPart(part);
            fragments.add(fragment);
        }
        return fragments;
    }

    public static class PatternFragment {
        private final Type type;
        private final String value;

        public PatternFragment(Type type, String value) {
            this.type = type;
            this.value = value;
        }

        public Type type() {
            return this.type;
        }

        public String value() {
            return this.value;
        }

        public static enum Type {
            EXACT,
            PREFIX,
            PROPER_PREFIX,
            SUFFIX,
            PROPER_SUFFIX,
            REGEX;

        }
    }
}

