/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.MetadataAttribute;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.CollectionUtils;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.expression.function.TimestampAware;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.expression.function.aggregate.DimensionValues;
import org.elasticsearch.xpack.esql.expression.function.aggregate.HistogramMergeOverTime;
import org.elasticsearch.xpack.esql.expression.function.aggregate.LastOverTime;
import org.elasticsearch.xpack.esql.expression.function.aggregate.TimeSeriesAggregateFunction;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Values;
import org.elasticsearch.xpack.esql.expression.function.grouping.Bucket;
import org.elasticsearch.xpack.esql.expression.function.grouping.TBucket;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateTrunc;
import org.elasticsearch.xpack.esql.expression.function.scalar.histogram.ExtractHistogramComponent;
import org.elasticsearch.xpack.esql.expression.function.scalar.internal.PackDimension;
import org.elasticsearch.xpack.esql.expression.function.scalar.internal.UnpackDimension;
import org.elasticsearch.xpack.esql.optimizer.LogicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.OptimizerRules;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.logical.TimeSeriesAggregate;

public final class TranslateTimeSeriesAggregate
extends OptimizerRules.ParameterizedOptimizerRule<TimeSeriesAggregate, LogicalOptimizerContext> {
    public TranslateTimeSeriesAggregate() {
        super(OptimizerRules.TransformDirection.UP);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected LogicalPlan rule(TimeSeriesAggregate aggregate, LogicalOptimizerContext context) {
        void var24_31;
        List<String> timestampAwareFunctions;
        Holder tsid = new Holder();
        Holder timestamp = new Holder();
        aggregate.forEachDown(EsRelation.class, r -> {
            for (Attribute attr : r.output()) {
                if (attr.name().equals("_tsid")) {
                    tsid.set((Object)attr);
                }
                if (!attr.name().equals("@timestamp")) continue;
                timestamp.set((Object)attr);
            }
        });
        if (tsid.get() == null) {
            tsid.set((Object)new MetadataAttribute(aggregate.source(), "_tsid", DataType.TSID_DATA_TYPE, false));
        }
        if (timestamp.get() == null) {
            throw new IllegalArgumentException("@timestamp field is missing from the time-series source");
        }
        HashMap<AggregateFunction, Alias> timeSeriesAggs = new HashMap<AggregateFunction, Alias>();
        ArrayList<Alias> firstPassAggs = new ArrayList<Alias>();
        ArrayList<Alias> secondPassAggs = new ArrayList<Alias>();
        Holder requiredTimeSeriesSource = new Holder((Object)Boolean.FALSE);
        InternalNames internalNames = new InternalNames();
        for (NamedExpression namedExpression : aggregate.aggregates()) {
            LastOverTime tsAgg2;
            Expression inlineFilter;
            Alias alias;
            Expression expression;
            if (!(namedExpression instanceof Alias) || !((expression = (alias = (Alias)namedExpression).child()) instanceof AggregateFunction)) continue;
            AggregateFunction af = (AggregateFunction)expression;
            Holder changed = new Holder((Object)Boolean.FALSE);
            if (af.hasFilter()) {
                inlineFilter = af.filter();
                af = af.withFilter(Literal.TRUE);
            } else {
                inlineFilter = null;
            }
            Expression outerAgg = af.transformDown(TimeSeriesAggregateFunction.class, tsAgg -> {
                if (inlineFilter != null) {
                    if (!tsAgg.hasFilter()) {
                        throw new IllegalStateException("inline filter isn't propagated to time-series aggregation");
                    }
                } else if (tsAgg.hasFilter()) {
                    throw new IllegalStateException("unexpected inline filter in time-series aggregation");
                }
                changed.set((Object)Boolean.TRUE);
                if (tsAgg.requiredTimeSeriesSource()) {
                    requiredTimeSeriesSource.set((Object)Boolean.TRUE);
                }
                AggregateFunction firstStageFn = tsAgg.perTimeSeriesAggregation();
                Alias newAgg = timeSeriesAggs.computeIfAbsent(firstStageFn, k -> {
                    Alias firstStageAlias = new Alias(tsAgg.source(), internalNames.next(tsAgg.functionName()), firstStageFn);
                    firstPassAggs.add(firstStageAlias);
                    return firstStageAlias;
                });
                return newAgg.toAttribute();
            });
            if (((Boolean)changed.get()).booleanValue()) {
                secondPassAggs.add(new Alias(alias.source(), alias.name(), outerAgg, namedExpression.id()));
                continue;
            }
            Expression aggField = TranslateTimeSeriesAggregate.findAggregatedField(af);
            if (aggField.dataType() == DataType.EXPONENTIAL_HISTOGRAM || aggField.dataType() == DataType.TDIGEST) {
                HistogramMergeOverTime tsAgg22 = new HistogramMergeOverTime(af.source(), aggField, Literal.TRUE, af.window());
            } else {
                tsAgg2 = new LastOverTime(af.source(), aggField, af.window(), (Expression)timestamp.get());
            }
            AggregateFunction firstStageFn = inlineFilter != null ? ((TimeSeriesAggregateFunction)tsAgg2).perTimeSeriesAggregation().withFilter(inlineFilter) : ((TimeSeriesAggregateFunction)tsAgg2).perTimeSeriesAggregation();
            Alias newAgg = timeSeriesAggs.computeIfAbsent(firstStageFn, k -> {
                Alias firstStageAlias = new Alias(tsAgg22.source(), internalNames.next(tsAgg22.functionName()), firstStageFn);
                firstPassAggs.add(firstStageAlias);
                return firstStageAlias;
            });
            secondPassAggs.add((Alias)namedExpression.transformUp(f -> f == aggField || f instanceof AggregateFunction, e -> {
                if (e == aggField) {
                    return newAgg.toAttribute();
                }
                if (e instanceof AggregateFunction) {
                    AggregateFunction f = (AggregateFunction)e;
                    return f.withFilter(Literal.TRUE);
                }
                return e;
            }));
        }
        if (!aggregate.child().output().contains(timestamp.get()) && !(timestampAwareFunctions = timeSeriesAggs.keySet().stream().filter(ts -> ts instanceof TimestampAware).map(Node::sourceText).sorted().toList()).isEmpty()) {
            int n = timestampAwareFunctions.size();
            throw new IllegalArgumentException("Function" + (n > 1 ? "s " : " ") + "[" + String.join((CharSequence)", ", timestampAwareFunctions.subList(0, Math.min(n, 3))) + (n > 3 ? ", ..." : "") + "] require" + (n > 1 ? " " : "s ") + "a @timestamp field of type date or date_nanos to be present when run with the TS command, but it was not present.");
        }
        ArrayList<Expression> firstPassGroupings = new ArrayList<Expression>();
        firstPassGroupings.add((Expression)tsid.get());
        ArrayList<Alias> arrayList = new ArrayList<Alias>();
        ArrayList<Expression> secondPassGroupings = new ArrayList<Expression>();
        ArrayList<Alias> unpackDimensions = new ArrayList<Alias>();
        Holder timeBucketRef = new Holder();
        aggregate.child().forEachExpressionUp(NamedExpression.class, e -> {
            for (Expression child : e.children()) {
                DateTrunc dateTrunc;
                Bucket bucket;
                TBucket tbucket;
                Bucket bucket2;
                if (child instanceof Bucket && (bucket2 = (Bucket)child).field().equals(timestamp.get())) {
                    if (timeBucketRef.get() != null) {
                        throw new IllegalArgumentException("expected at most one time bucket");
                    }
                    timeBucketRef.set(e);
                    continue;
                }
                if (child instanceof TBucket && (tbucket = (TBucket)child).timestamp().equals(timestamp.get())) {
                    if (timeBucketRef.get() != null) {
                        throw new IllegalArgumentException("expected at most one time tbucket");
                    }
                    bucket = (Bucket)tbucket.surrogate();
                    timeBucketRef.set((Object)new Alias(e.source(), bucket.functionName(), bucket, e.id()));
                    continue;
                }
                if (!(child instanceof DateTrunc) || !(dateTrunc = (DateTrunc)child).field().equals(timestamp.get())) continue;
                if (timeBucketRef.get() != null) {
                    throw new IllegalArgumentException("expected at most one time bucket");
                }
                bucket = new Bucket(dateTrunc.source(), dateTrunc.field(), dateTrunc.interval(), null, null, dateTrunc.configuration());
                timeBucketRef.set((Object)new Alias(e.source(), bucket.functionName(), bucket, e.id()));
            }
        });
        NamedExpression timeBucket = (NamedExpression)timeBucketRef.get();
        boolean[] packPositions = new boolean[aggregate.groupings().size()];
        for (int i = 0; i < aggregate.groupings().size(); ++i) {
            Expression group = aggregate.groupings().get(i);
            if (!(group instanceof Attribute)) {
                throw new EsqlIllegalArgumentException("expected named expression for grouping; got " + String.valueOf(group));
            }
            Attribute g = (Attribute)group;
            if (timeBucket != null && g.id().equals(timeBucket.id())) {
                Attribute newFinalGroup = timeBucket.toAttribute();
                firstPassGroupings.add(newFinalGroup);
                secondPassGroupings.add(new Alias(g.source(), g.name(), newFinalGroup.toAttribute(), g.id()));
                continue;
            }
            Alias valuesAgg = new Alias(g.source(), g.name(), this.valuesAggregate(context, g));
            firstPassAggs.add(valuesAgg);
            if (g.isDimension()) {
                Alias pack = new Alias(g.source(), internalNames.next("pack_" + g.name()), new PackDimension(g.source(), valuesAgg.toAttribute()));
                arrayList.add(pack);
                Alias grouping = new Alias(g.source(), internalNames.next("group_" + g.name()), pack.toAttribute());
                secondPassGroupings.add(grouping);
                Alias unpack = new Alias(g.source(), g.name(), new UnpackDimension(g.source(), grouping.toAttribute(), g.dataType().noText()), g.id());
                unpackDimensions.add(unpack);
                packPositions[i] = true;
                continue;
            }
            secondPassGroupings.add(new Alias(g.source(), g.name(), valuesAgg.toAttribute(), g.id()));
        }
        LogicalPlan newChild = aggregate.child().transformUp(EsRelation.class, r -> {
            IndexMode indexMode;
            IndexMode indexMode2 = indexMode = (Boolean)requiredTimeSeriesSource.get() != false ? r.indexMode() : IndexMode.STANDARD;
            if (!r.output().contains(tsid.get())) {
                return r.withIndexMode(indexMode).withAttributes(CollectionUtils.combine(r.output(), (Attribute)tsid.get()));
            }
            return r.withIndexMode(indexMode);
        });
        TimeSeriesAggregate firstPhase = new TimeSeriesAggregate(aggregate.source(), newChild, firstPassGroupings, TranslateTimeSeriesAggregate.mergeExpressions(firstPassAggs, firstPassGroupings), (Bucket)Alias.unwrap(timeBucket));
        this.checkWindow(firstPhase);
        if (arrayList.isEmpty()) {
            return new Aggregate(firstPhase.source(), firstPhase, secondPassGroupings, TranslateTimeSeriesAggregate.mergeExpressions(secondPassAggs, secondPassGroupings));
        }
        Eval packValues = new Eval(firstPhase.source(), firstPhase, arrayList);
        Aggregate secondPhase = new Aggregate(firstPhase.source(), packValues, secondPassGroupings, TranslateTimeSeriesAggregate.mergeExpressions(secondPassAggs, secondPassGroupings));
        Eval unpackValues = new Eval(secondPhase.source(), secondPhase, unpackDimensions);
        ArrayList<Attribute> projects = new ArrayList<Attribute>();
        for (NamedExpression namedExpression : secondPassAggs) {
            projects.add(Expressions.attribute(namedExpression));
        }
        int packPos = 0;
        boolean bl = false;
        while (var24_31 < secondPassGroupings.size()) {
            if (packPositions[var24_31]) {
                projects.add(((Alias)unpackDimensions.get(packPos++)).toAttribute());
            } else {
                projects.add(Expressions.attribute((Expression)secondPassGroupings.get((int)var24_31)));
            }
            ++var24_31;
        }
        return new Project(newChild.source(), unpackValues, projects);
    }

    private static Expression findAggregatedField(AggregateFunction af) {
        Expression aggregatedExpression = af.field();
        if (aggregatedExpression instanceof ExtractHistogramComponent) {
            ExtractHistogramComponent extractHistogramComponent = (ExtractHistogramComponent)aggregatedExpression;
            return extractHistogramComponent.field();
        }
        return aggregatedExpression;
    }

    private static List<? extends NamedExpression> mergeExpressions(List<? extends NamedExpression> aggregates, List<Expression> groupings) {
        ArrayList<? extends NamedExpression> merged = new ArrayList<NamedExpression>(aggregates.size() + groupings.size());
        merged.addAll(aggregates);
        groupings.forEach(g -> merged.add(Expressions.attribute(g)));
        return merged;
    }

    private AggregateFunction valuesAggregate(LogicalOptimizerContext context, Attribute group) {
        if (group.isDimension() && context.minimumVersion().supports(DimensionValues.DIMENSION_VALUES_VERSION)) {
            return new DimensionValues(group.source(), group);
        }
        return new Values(group.source(), group);
    }

    void checkWindow(TimeSeriesAggregate agg) {
        boolean hasWindow = false;
        for (NamedExpression namedExpression : agg.aggregates()) {
            AggregateFunction af;
            Expression expression = Alias.unwrap(namedExpression);
            if (!(expression instanceof AggregateFunction) || !(af = (AggregateFunction)expression).hasWindow()) continue;
            hasWindow = true;
            break;
        }
        if (!hasWindow) {
            return;
        }
        long bucketInMillis = this.getTimeBucketInMillis(agg);
        if (bucketInMillis <= 0L) {
            throw new IllegalArgumentException("Using a window in aggregation [" + agg.sourceText() + "] requires a time bucket in groupings");
        }
        for (NamedExpression namedExpression : agg.aggregates()) {
            Duration d;
            long windowInMills;
            Object object;
            Expression window;
            AggregateFunction af;
            Expression expression = Alias.unwrap(namedExpression);
            if (!(expression instanceof AggregateFunction) || !(af = (AggregateFunction)expression).hasWindow() || (window = af.window()).foldable() && (object = window.fold(FoldContext.small())) instanceof Duration && (windowInMills = (d = (Duration)object).toMillis()) >= bucketInMillis && windowInMills % bucketInMillis == 0L) continue;
            throw new IllegalArgumentException("Unsupported window [" + window.sourceText() + "] for aggregate function [" + af.sourceText() + "]; the window must be larger than the time bucket [" + Objects.requireNonNull(agg.timeBucket()).sourceText() + "] and an exact multiple of it");
        }
    }

    private long getTimeBucketInMillis(TimeSeriesAggregate agg) {
        Object object;
        Bucket bucket = agg.timeBucket();
        if (bucket != null && bucket.buckets().foldable() && (object = bucket.buckets().fold(FoldContext.small())) instanceof Duration) {
            Duration d = (Duration)object;
            return d.toMillis();
        }
        return -1L;
    }

    private static class InternalNames {
        final Map<String, Integer> next = new HashMap<String, Integer>();

        private InternalNames() {
        }

        String next(String prefix) {
            int id = this.next.merge(prefix, 1, Integer::sum);
            return prefix + "_$" + id;
        }
    }
}

