/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical;

import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.NameId;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;

class TemporaryNameUtils {
    static int TO_STRING_LIMIT = 16;

    TemporaryNameUtils() {
    }

    public static String temporaryName(Expression inner, Expression outer, int suffix) {
        String in = TemporaryNameUtils.toString(inner);
        String out = TemporaryNameUtils.toString(outer);
        return Attribute.rawTemporaryName(in, out, String.valueOf(suffix));
    }

    public static String locallyUniqueTemporaryName(String inner) {
        return Attribute.rawTemporaryName(inner, "temp_name", new NameId().toString());
    }

    static String toString(Expression ex) {
        String string;
        if (ex instanceof AggregateFunction) {
            AggregateFunction af = (AggregateFunction)ex;
            string = af.functionName();
        } else {
            string = TemporaryNameUtils.extractString(ex);
        }
        return string;
    }

    static String extractString(Expression ex) {
        String string;
        if (ex instanceof NamedExpression) {
            NamedExpression ne = (NamedExpression)ex;
            string = ne.name();
        } else {
            string = TemporaryNameUtils.limitToString(ex.sourceText()).replace(' ', '_');
        }
        return string;
    }

    static String limitToString(String string) {
        return string.length() > TO_STRING_LIMIT ? string.substring(0, TO_STRING_LIMIT - 1) + ">" : string;
    }
}

