/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.expression.Order;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.OptimizerRules;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.OrderBy;
import org.elasticsearch.xpack.esql.plan.logical.Project;

public final class ReplaceOrderByExpressionWithEval
extends OptimizerRules.OptimizerRule<OrderBy> {
    private static int counter = 0;

    @Override
    protected LogicalPlan rule(OrderBy orderBy) {
        int size = orderBy.order().size();
        ArrayList<Alias> evals = new ArrayList<Alias>(size);
        ArrayList<Order> newOrders = new ArrayList<Order>(size);
        for (int i = 0; i < size; ++i) {
            Order order = orderBy.order().get(i);
            if (!(order.child() instanceof Attribute)) {
                String name = Attribute.rawTemporaryName("order_by", String.valueOf(i), String.valueOf(counter++));
                Alias eval = new Alias(order.child().source(), name, order.child());
                newOrders.add((Order)order.replaceChildren(List.of(eval.toAttribute())));
                evals.add(eval);
                continue;
            }
            newOrders.add(order);
        }
        if (evals.isEmpty()) {
            return orderBy;
        }
        OrderBy newOrderBy = new OrderBy(orderBy.source(), new Eval(orderBy.source(), orderBy.child(), evals), newOrders);
        return new Project(orderBy.source(), newOrderBy, orderBy.output());
    }
}

