/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeMap;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.expression.NamedExpressions;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.TemporaryNameUtils;
import org.elasticsearch.xpack.esql.plan.GeneratingPlan;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.OrderBy;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;

class PushDownUtils {
    PushDownUtils() {
    }

    public static <Plan extends UnaryPlan> LogicalPlan pushGeneratingPlanPastProjectAndOrderBy(Plan generatingPlan) {
        LogicalPlan child = generatingPlan.child();
        if (child instanceof OrderBy) {
            OrderBy orderBy = (OrderBy)child;
            HashSet<String> generatedFieldNames = new HashSet<String>(Expressions.names(((GeneratingPlan)((Object)generatingPlan)).generatedAttributes()));
            AttributeReplacement nonShadowedOrders = PushDownUtils.renameAttributesInExpressions(generatedFieldNames, orderBy.order());
            AttributeMap<Alias> aliasesForShadowedOrderByAttrs = nonShadowedOrders.replacedAttributes;
            List<Expression> newOrder = nonShadowedOrders.rewrittenExpressions;
            if (!aliasesForShadowedOrderByAttrs.isEmpty()) {
                ArrayList<Alias> arrayList = new ArrayList<Alias>(aliasesForShadowedOrderByAttrs.values());
                UnaryPlan plan = new Eval(orderBy.source(), orderBy.child(), arrayList);
                plan = generatingPlan.replaceChild(plan);
                plan = new OrderBy(orderBy.source(), plan, newOrder);
                plan = new Project(generatingPlan.source(), plan, generatingPlan.output());
                return plan;
            }
            return orderBy.replaceChild(generatingPlan.replaceChild(orderBy.child()));
        }
        if (child instanceof Project) {
            Project project = (Project)child;
            List<Attribute> generatedAttributes = ((GeneratingPlan)((Object)generatingPlan)).generatedAttributes();
            Plan generatingPlanWithResolvedExpressions = PushDownUtils.resolveRenamesFromProject(generatingPlan, project);
            HashSet<String> namesReferencedInRenames = new HashSet<String>();
            for (NamedExpression namedExpression : project.projections()) {
                if (!(namedExpression instanceof Alias)) continue;
                Alias as = (Alias)namedExpression;
                namesReferencedInRenames.addAll(as.child().references().names());
            }
            Map<String, String> renameGeneratedAttributeTo = PushDownUtils.newNamesForConflictingAttributes(((GeneratingPlan)((Object)generatingPlan)).generatedAttributes(), namesReferencedInRenames);
            List<String> list = generatedAttributes.stream().map(attr -> renameGeneratedAttributeTo.getOrDefault(attr.name(), attr.name())).toList();
            UnaryPlan generatingPlanWithRenamedAttributes = (UnaryPlan)((GeneratingPlan)((Object)generatingPlanWithResolvedExpressions)).withGeneratedNames(list);
            ArrayList<NamedExpression> generatedAttributesRenamedToOriginal = new ArrayList<NamedExpression>(generatedAttributes.size());
            List<Attribute> renamedGeneratedAttributes = ((GeneratingPlan)((Object)generatingPlanWithRenamedAttributes)).generatedAttributes();
            for (int i = 0; i < generatedAttributes.size(); ++i) {
                Attribute originalAttribute = generatedAttributes.get(i);
                Attribute renamedAttribute = renamedGeneratedAttributes.get(i);
                if (originalAttribute.name().equals(renamedAttribute.name())) {
                    generatedAttributesRenamedToOriginal.add(renamedAttribute);
                    continue;
                }
                generatedAttributesRenamedToOriginal.add(new Alias(originalAttribute.source(), originalAttribute.name(), renamedAttribute, originalAttribute.id(), originalAttribute.synthetic()));
            }
            Project projectWithGeneratingChild = project.replaceChild(generatingPlanWithRenamedAttributes.replaceChild(project.child()));
            return projectWithGeneratingChild.withProjections(NamedExpressions.mergeOutputExpressions(generatedAttributesRenamedToOriginal, projectWithGeneratingChild.projections()));
        }
        return generatingPlan;
    }

    private static AttributeReplacement renameAttributesInExpressions(Set<String> attributeNamesToRename, List<? extends Expression> expressions) {
        AttributeMap.Builder aliasesForReplacedAttributesBuilder = AttributeMap.builder();
        ArrayList<Expression> rewrittenExpressions = new ArrayList<Expression>();
        for (Expression expression : expressions) {
            rewrittenExpressions.add(expression.transformUp(Attribute.class, attr -> {
                if (attributeNamesToRename.contains(attr.name())) {
                    Alias renamedAttribute = aliasesForReplacedAttributesBuilder.computeIfAbsent((Attribute)attr, a -> {
                        String tempName = TemporaryNameUtils.locallyUniqueTemporaryName(a.name());
                        return new Alias(a.source(), tempName, (Expression)a, null, true);
                    });
                    return renamedAttribute.toAttribute();
                }
                return attr;
            }));
        }
        return new AttributeReplacement(rewrittenExpressions, aliasesForReplacedAttributesBuilder.build());
    }

    private static Map<String, String> newNamesForConflictingAttributes(List<Attribute> potentiallyConflictingAttributes, Set<String> reservedNames) {
        if (reservedNames.isEmpty()) {
            return Map.of();
        }
        HashMap<String, String> renameAttributeTo = new HashMap<String, String>();
        for (Attribute attr : potentiallyConflictingAttributes) {
            String name = attr.name();
            if (!reservedNames.contains(name)) continue;
            renameAttributeTo.putIfAbsent(name, TemporaryNameUtils.locallyUniqueTemporaryName(name));
        }
        return renameAttributeTo;
    }

    public static Project pushDownPastProject(UnaryPlan parent) {
        LogicalPlan logicalPlan = parent.child();
        if (logicalPlan instanceof Project) {
            Project project = (Project)logicalPlan;
            UnaryPlan expressionsWithResolvedAliases = PushDownUtils.resolveRenamesFromProject(parent, project);
            return project.replaceChild(expressionsWithResolvedAliases.replaceChild(project.child()));
        }
        throw new EsqlIllegalArgumentException("Expected child to be instance of Project");
    }

    private static <P extends LogicalPlan> P resolveRenamesFromProject(P plan, Project project) {
        AttributeMap.Builder aliasBuilder = AttributeMap.builder();
        project.forEachExpression(Alias.class, a -> aliasBuilder.put(a.toAttribute(), a.child()));
        AttributeMap<Expression> aliases = aliasBuilder.build();
        return PushDownUtils.resolveRenamesFromMap(plan, aliases);
    }

    public static <P extends LogicalPlan> P resolveRenamesFromMap(P plan, AttributeMap<Expression> map) {
        return (P)((LogicalPlan)plan.transformExpressionsOnly(Attribute.class, r -> map.resolve(r, (Expression)r)));
    }

    private record AttributeReplacement(List<Expression> rewrittenExpressions, AttributeMap<Alias> replacedAttributes) {
    }
}

