/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical;

import java.util.List;
import org.elasticsearch.xpack.esql.core.expression.AttributeMap;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.ReferenceAttribute;
import org.elasticsearch.xpack.esql.optimizer.LogicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.rules.RuleUtils;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Filter;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.rule.ParameterizedRule;

public final class PropagateEvalFoldables
extends ParameterizedRule<LogicalPlan, LogicalPlan, LogicalOptimizerContext> {
    @Override
    public LogicalPlan apply(LogicalPlan plan, LogicalOptimizerContext ctx) {
        AttributeMap<Expression> collectRefs = RuleUtils.foldableReferences(plan, ctx);
        if (collectRefs.isEmpty()) {
            return plan;
        }
        AttributeMap.Builder<Expression> builder = AttributeMap.builder();
        builder.putAll(collectRefs);
        plan = plan.transformUp(p -> {
            if (p instanceof Aggregate) {
                Aggregate aggregate = (Aggregate)p;
                aggregate.groupings().forEach(group -> {
                    Literal literal;
                    Expression resolved = collectRefs.resolve(group, (Expression)group);
                    if (resolved instanceof Literal && (literal = (Literal)resolved).value() instanceof List) {
                        builder.remove(group);
                    }
                });
            }
            if (p instanceof Filter || p instanceof Eval) {
                p = (LogicalPlan)p.transformExpressionsOnly(ReferenceAttribute.class, r -> builder.build().resolve(r, (ReferenceAttribute)r));
            }
            return p;
        });
        return plan;
    }
}

