/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeMap;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.expression.Order;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.OptimizerRules;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.TemporaryNameUtils;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.OrderBy;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.logical.SortPreserving;
import org.elasticsearch.xpack.esql.plan.logical.join.InlineJoin;

public final class HoistOrderByBeforeInlineJoin
extends OptimizerRules.OptimizerRule<LogicalPlan>
implements OptimizerRules.CoordinatorOnly {
    @Override
    protected LogicalPlan rule(LogicalPlan plan) {
        return plan.transformUp(InlineJoin.class, HoistOrderByBeforeInlineJoin::hoistOrderByBeforeInlineJoin);
    }

    private static LogicalPlan hoistOrderByBeforeInlineJoin(InlineJoin inlineJoin) {
        Holder orderByHolder = new Holder();
        inlineJoin.forEachDownMayReturnEarly((node, breakEarly) -> {
            if (node instanceof OrderBy) {
                OrderBy orderBy = (OrderBy)node;
                orderByHolder.set((Object)orderBy);
                breakEarly.set((Object)true);
            } else {
                breakEarly.set((Object)(!(node instanceof SortPreserving) ? 1 : 0));
            }
        });
        OrderBy orderBy = (OrderBy)orderByHolder.get();
        return orderBy == null ? inlineJoin : HoistOrderByBeforeInlineJoin.hoistOrderByBeforeInlineJoin(inlineJoin, orderBy);
    }

    private static LogicalPlan hoistOrderByBeforeInlineJoin(InlineJoin inlineJoin, OrderBy orderBy) {
        ArrayList<Alias> evalAliases = new ArrayList<Alias>();
        AttributeMap.Builder<Attribute> orderByAttrMapBuilder = AttributeMap.builder();
        for (Order order : orderBy.order()) {
            Expression orderExpression = order.child();
            Attribute orderAttribute = Expressions.attribute(orderExpression);
            if (inlineJoin.inputSet().contains(orderAttribute) && inlineJoin.outputSet().contains(orderAttribute)) continue;
            Alias orderAlias = new Alias(orderBy.source(), TemporaryNameUtils.locallyUniqueTemporaryName(orderAttribute.name()), orderExpression);
            evalAliases.add(orderAlias);
            orderByAttrMapBuilder.put(orderAttribute, Expressions.attribute(orderAlias));
        }
        return evalAliases.isEmpty() ? orderBy.replaceChild(inlineJoin.transformUp(OrderBy.class, ob -> ob == orderBy ? orderBy.child() : ob)) : HoistOrderByBeforeInlineJoin.hoistRewritingMidProjections(inlineJoin, orderBy, evalAliases, orderByAttrMapBuilder.build());
    }

    private static LogicalPlan hoistRewritingMidProjections(InlineJoin inlineJoin, OrderBy orderBy, List<Alias> evalAliases, AttributeMap<Attribute> attrToTempAliasMap) {
        Eval eval = new Eval(orderBy.source(), orderBy.child(), evalAliases);
        LogicalPlan newInlineJoin = inlineJoin.transformUp(OrderBy.class, ob -> ob == orderBy ? eval : ob);
        OrderBy newOrderBy = orderBy.replaceChild(HoistOrderByBeforeInlineJoin.rewriteMidProjections(newInlineJoin, eval, attrToTempAliasMap));
        newOrderBy = (OrderBy)newOrderBy.transformExpressionsOnly(Attribute.class, a -> attrToTempAliasMap.resolve(a, (Attribute)a));
        return new Project(orderBy.source(), newOrderBy, inlineJoin.output());
    }

    private static LogicalPlan rewriteMidProjections(LogicalPlan plan, Eval eval, AttributeMap<Attribute> attrToTempAliasMap) {
        Holder evalVisited = new Holder((Object)false);
        return plan.transformUp(lp -> {
            if (lp == eval) {
                evalVisited.set((Object)true);
            } else if (lp instanceof Project) {
                Project project = (Project)lp;
                if (((Boolean)evalVisited.get()).booleanValue()) {
                    ArrayList<? extends NamedExpression> newProjections = new ArrayList<NamedExpression>(project.projections());
                    for (Map.Entry attrSet : attrToTempAliasMap.entrySet()) {
                        if (!project.inputSet().contains(attrSet.getKey()) && !project.inputSet().contains(attrSet.getValue()) || project.projections().contains(attrSet.getValue())) continue;
                        newProjections.add((NamedExpression)attrSet.getValue());
                    }
                    lp = project.withProjections(newProjections);
                }
            }
            return lp;
        });
    }
}

