/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Predicate;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeMap;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.expression.ReferenceAttribute;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.optimizer.LogicalOptimizerContext;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;

public final class RuleUtils {
    private RuleUtils() {
    }

    public static Tuple<List<Alias>, List<NamedExpression>> aliasedNulls(List<Attribute> outputAttributes, Predicate<Attribute> shouldBeReplaced) {
        LinkedHashMap nullLiterals = Maps.newLinkedHashMapWithExpectedSize((int)DataType.types().size());
        ArrayList<Attribute> newProjections = new ArrayList<Attribute>(outputAttributes.size());
        for (Attribute attr : outputAttributes) {
            NamedExpression projection;
            if (shouldBeReplaced.test(attr)) {
                DataType dt = attr.dataType();
                Alias nullAlias = (Alias)nullLiterals.get((Object)dt);
                if (nullAlias == null) {
                    Alias alias = new Alias(attr.source(), attr.name(), Literal.of(attr, null), attr.id());
                    nullLiterals.put(dt, alias);
                    projection = alias.toAttribute();
                } else {
                    projection = new Alias(attr.source(), attr.name(), nullAlias.toAttribute(), attr.id());
                }
            } else {
                projection = attr;
            }
            newProjections.add((Attribute)projection);
        }
        return new Tuple(new ArrayList(nullLiterals.values()), newProjections);
    }

    public static AttributeMap<Expression> foldableReferences(LogicalPlan plan, LogicalOptimizerContext ctx) {
        AttributeMap.Builder collectRefsBuilder = AttributeMap.builder();
        plan.forEachExpressionUp(Alias.class, a -> {
            Expression c = a.child();
            boolean shouldCollect = c.foldable();
            if (!shouldCollect) {
                c = c.transformUp(ReferenceAttribute.class, r -> collectRefsBuilder.build().resolve(r, (ReferenceAttribute)r));
                shouldCollect = c.foldable();
            }
            if (shouldCollect) {
                collectRefsBuilder.put(a.toAttribute(), Literal.of(ctx.foldCtx(), c));
            }
        });
        return collectRefsBuilder.build();
    }
}

