/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules;

import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.plan.QueryPlan;
import org.elasticsearch.xpack.esql.plan.logical.BinaryPlan;
import org.elasticsearch.xpack.esql.plan.logical.Fork;
import org.elasticsearch.xpack.esql.plan.physical.BinaryExec;
import org.elasticsearch.xpack.esql.plan.physical.MergeExec;

public class PlanConsistencyChecker {
    public static void checkPlan(QueryPlan<?> p, Failures failures) {
        if (p instanceof BinaryPlan) {
            BinaryPlan binaryPlan = (BinaryPlan)p;
            PlanConsistencyChecker.checkMissingBinary(p, binaryPlan.leftReferences(), binaryPlan.left().outputSet(), binaryPlan.rightReferences(), binaryPlan.right().outputSet(), failures);
        } else if (p instanceof BinaryExec) {
            BinaryExec binaryExec = (BinaryExec)p;
            PlanConsistencyChecker.checkMissingBinary(p, binaryExec.leftReferences(), binaryExec.left().outputSet(), binaryExec.rightReferences(), binaryExec.right().outputSet(), failures);
        } else if (p instanceof Fork || p instanceof MergeExec) {
            PlanConsistencyChecker.checkMissingFork(p, failures);
        } else {
            PlanConsistencyChecker.checkMissing(p, p.references(), p.inputSet(), "missing references", failures);
        }
        HashSet outputAttributeNames = Sets.newHashSetWithExpectedSize((int)p.output().size());
        HashSet outputAttributeIds = Sets.newHashSetWithExpectedSize((int)p.output().size());
        for (Attribute outputAttr : p.output()) {
            if (outputAttributeNames.add(outputAttr.name()) && outputAttributeIds.add(outputAttr.id())) continue;
            failures.add(Failure.fail(p, "Plan [{}] optimized incorrectly due to duplicate output attribute {}", p.nodeString(), outputAttr.toString()));
        }
    }

    private static void checkMissingFork(QueryPlan<?> plan, Failures failures) {
        for (QueryPlan child : plan.children()) {
            PlanConsistencyChecker.checkMissingForkBranch(child, plan.outputSet(), failures);
        }
    }

    private static void checkMissingForkBranch(QueryPlan<?> plan, AttributeSet forkOutputSet, Failures failures) {
        Map<String, DataType> attributeTypes = forkOutputSet.stream().collect(Collectors.toMap(NamedExpression::name, Expression::dataType));
        HashSet missing = new HashSet();
        HashSet commonAttrs = new HashSet();
        plan.output().forEach(attribute -> {
            DataType attrType = (DataType)((Object)((Object)attributeTypes.get(attribute.name())));
            if (attrType == null || attrType != attribute.dataType() && attrType != DataType.UNSUPPORTED) {
                missing.add(attribute);
            }
            commonAttrs.add(attribute.name());
        });
        forkOutputSet.forEach((Consumer<? super Attribute>)((Consumer<Attribute>)attribute -> {
            if (!commonAttrs.contains(attribute.name())) {
                missing.add(attribute);
            }
        }));
        if (!missing.isEmpty()) {
            failures.add(Failure.fail(plan, "Plan [{}] optimized incorrectly due to missing attributes in subplans: [{}]", plan.nodeString(), ((Object)missing).toString()));
        }
    }

    private static void checkMissingBinary(QueryPlan<?> plan, AttributeSet leftReferences, AttributeSet leftInput, AttributeSet rightReferences, AttributeSet rightInput, Failures failures) {
        PlanConsistencyChecker.checkMissing(plan, leftReferences, leftInput, "missing references from left hand side", failures);
        PlanConsistencyChecker.checkMissing(plan, rightReferences, rightInput, "missing references from right hand side", failures);
    }

    private static void checkMissing(QueryPlan<?> plan, AttributeSet references, AttributeSet input, String detailErrorMessage, Failures failures) {
        AttributeSet missing = references.subtract(input);
        if (!missing.isEmpty()) {
            failures.add(Failure.fail(plan, "Plan [{}] optimized incorrectly due to {} {}", plan.nodeString(), detailErrorMessage, missing));
        }
    }
}

