/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer;

import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.xpack.esql.optimizer.LogicalPreOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.preoptimizer.FoldInferenceFunctions;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.preoptimizer.LogicalPlanPreOptimizerRule;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;

public class LogicalPlanPreOptimizer {
    private final List<LogicalPlanPreOptimizerRule> preOptimizerRules;

    public LogicalPlanPreOptimizer(LogicalPreOptimizerContext preOptimizerContext) {
        this(List.of(new FoldInferenceFunctions(preOptimizerContext)));
    }

    LogicalPlanPreOptimizer(List<LogicalPlanPreOptimizerRule> preOptimizerRules) {
        this.preOptimizerRules = preOptimizerRules;
    }

    public void preOptimize(LogicalPlan plan, ActionListener<LogicalPlan> listener) {
        if (!plan.analyzed()) {
            listener.onFailure((Exception)new IllegalStateException("Expected analyzed plan"));
            return;
        }
        this.doPreOptimize(plan, (ActionListener<LogicalPlan>)listener.delegateFailureAndWrap((l, preOptimized) -> {
            preOptimized.setPreOptimized();
            listener.onResponse(preOptimized);
        }));
    }

    private void doPreOptimize(LogicalPlan plan, ActionListener<LogicalPlan> listener) {
        SubscribableListener rulesListener = SubscribableListener.newSucceeded((Object)plan);
        for (LogicalPlanPreOptimizerRule preOptimizerRule : this.preOptimizerRules) {
            rulesListener = rulesListener.andThen((l, p) -> preOptimizerRule.apply((LogicalPlan)p, (ActionListener<LogicalPlan>)l));
        }
        rulesListener.addListener(listener);
    }
}

