/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.xpack.esql.VerificationException;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.optimizer.LocalPhysicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.PhysicalVerifier;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.EnableSpatialDistancePushdown;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.ExtractDimensionFieldsAfterAggregation;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.InsertFieldExtraction;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.PushCountQueryAndTagsToSource;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.PushFiltersToSource;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.PushLimitToSource;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.PushSampleToSource;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.PushStatsToSource;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.PushTopNToSource;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.ReplaceRoundToWithQueryAndTags;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.ReplaceSourceAttributes;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.SpatialDocValuesExtraction;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.SpatialShapeBoundsExtraction;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.rule.ParameterizedRuleExecutor;
import org.elasticsearch.xpack.esql.rule.Rule;
import org.elasticsearch.xpack.esql.rule.RuleExecutor;

public class LocalPhysicalPlanOptimizer
extends ParameterizedRuleExecutor<PhysicalPlan, LocalPhysicalOptimizerContext> {
    private static final List<RuleExecutor.Batch<PhysicalPlan>> RULES = LocalPhysicalPlanOptimizer.rules(true);
    private final PhysicalVerifier verifier = PhysicalVerifier.LOCAL_INSTANCE;

    public LocalPhysicalPlanOptimizer(LocalPhysicalOptimizerContext context) {
        super(context);
    }

    public PhysicalPlan localOptimize(PhysicalPlan plan) {
        return this.verify(this.execute(plan), plan.output());
    }

    PhysicalPlan verify(PhysicalPlan optimizedPlan, List<Attribute> expectedOutputAttributes) {
        Failures failures = this.verifier.verify(optimizedPlan, expectedOutputAttributes);
        if (failures.hasFailures()) {
            throw new VerificationException(failures);
        }
        return optimizedPlan;
    }

    @Override
    protected List<RuleExecutor.Batch<PhysicalPlan>> batches() {
        return RULES;
    }

    protected static List<RuleExecutor.Batch<PhysicalPlan>> rules(boolean optimizeForEsSource) {
        ArrayList<Rule> esSourceRules = new ArrayList<Rule>(7);
        esSourceRules.add(new ReplaceSourceAttributes());
        if (optimizeForEsSource) {
            esSourceRules.add(new PushTopNToSource());
            esSourceRules.add(new PushLimitToSource());
            esSourceRules.add(new PushFiltersToSource());
            esSourceRules.add(new PushSampleToSource());
            esSourceRules.add(new PushStatsToSource());
            esSourceRules.add(new EnableSpatialDistancePushdown());
        }
        RuleExecutor.Batch pushdown = new RuleExecutor.Batch("Push to ES", (Rule[])esSourceRules.toArray(Rule[]::new));
        RuleExecutor.Batch substitutionRules = new RuleExecutor.Batch("Substitute RoundTo with QueryAndTags", RuleExecutor.Limiter.ONCE, new ReplaceRoundToWithQueryAndTags(), new PushCountQueryAndTagsToSource());
        RuleExecutor.Batch fieldExtraction = new RuleExecutor.Batch("Field extraction", RuleExecutor.Limiter.ONCE, new ExtractDimensionFieldsAfterAggregation(), new InsertFieldExtraction(), new SpatialDocValuesExtraction(), new SpatialShapeBoundsExtraction());
        return optimizeForEsSource ? List.of(pushdown, substitutionRules, fieldExtraction) : List.of(pushdown, fieldExtraction);
    }
}

