/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.xpack.esql.VerificationException;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.optimizer.LocalLogicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.LogicalPlanOptimizer;
import org.elasticsearch.xpack.esql.optimizer.LogicalVerifier;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.OptimizerRules;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.ReplaceStringCasingWithInsensitiveRegexMatch;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.local.IgnoreNullMetrics;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.local.InferIsNotNull;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.local.InferNonNullAggConstraint;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.local.PushExpressionsToFieldLoad;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.local.ReplaceDateTruncBucketWithRoundTo;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.local.ReplaceFieldWithConstantOrNull;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.local.ReplaceTopNWithLimitAndSort;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.rule.ParameterizedRuleExecutor;
import org.elasticsearch.xpack.esql.rule.Rule;
import org.elasticsearch.xpack.esql.rule.RuleExecutor;

public class LocalLogicalPlanOptimizer
extends ParameterizedRuleExecutor<LogicalPlan, LocalLogicalOptimizerContext> {
    private final LogicalVerifier verifier = LogicalVerifier.LOCAL_INSTANCE;
    private static final List<RuleExecutor.Batch<LogicalPlan>> RULES = CollectionUtils.arrayAsArrayList((Object[])new RuleExecutor.Batch[]{new RuleExecutor.Batch("Local rewrite", RuleExecutor.Limiter.ONCE, new IgnoreNullMetrics(), new ReplaceTopNWithLimitAndSort(), new ReplaceFieldWithConstantOrNull(), new InferIsNotNull(), new InferNonNullAggConstraint(), new ReplaceDateTruncBucketWithRoundTo(), new PushExpressionsToFieldLoad()), LocalLogicalPlanOptimizer.localOperators(), LocalLogicalPlanOptimizer.localCleanup()});

    public LocalLogicalPlanOptimizer(LocalLogicalOptimizerContext localLogicalOptimizerContext) {
        super(localLogicalOptimizerContext);
    }

    @Override
    protected List<RuleExecutor.Batch<LogicalPlan>> batches() {
        return RULES;
    }

    private static RuleExecutor.Batch<LogicalPlan> localOperators() {
        return LocalLogicalPlanOptimizer.localBatch(LogicalPlanOptimizer.operators(), new ReplaceStringCasingWithInsensitiveRegexMatch());
    }

    private static RuleExecutor.Batch<LogicalPlan> localCleanup() {
        return LocalLogicalPlanOptimizer.localBatch(LogicalPlanOptimizer.cleanup(), new Rule[0]);
    }

    private static RuleExecutor.Batch<LogicalPlan> localBatch(RuleExecutor.Batch<LogicalPlan> batch, Rule<?, LogicalPlan> ... additionalRules) {
        Rule<?, LogicalPlan>[] rules = batch.rules();
        ArrayList newRules = new ArrayList(rules.length);
        for (Rule<?, LogicalPlan> r : rules) {
            if (r instanceof OptimizerRules.LocalAware) {
                OptimizerRules.LocalAware localAware = (OptimizerRules.LocalAware)((Object)r);
                Rule local = localAware.local();
                if (local == null) continue;
                newRules.add(local);
                continue;
            }
            newRules.add(r);
        }
        newRules.addAll(Arrays.asList(additionalRules));
        return batch.with((Rule[])newRules.toArray(Rule[]::new));
    }

    public LogicalPlan localOptimize(LogicalPlan plan) {
        LogicalPlan optimized = this.execute(plan);
        Failures failures = this.verifier.verify(optimized, plan.output());
        if (failures.hasFailures()) {
            throw new VerificationException(failures);
        }
        return optimized;
    }
}

