/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.inference.rerank;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.core.inference.action.InferenceAction;
import org.elasticsearch.xpack.esql.inference.bulk.BulkInferenceRequestIterator;

class RerankOperatorRequestIterator
implements BulkInferenceRequestIterator {
    private final BytesRefBlock inputBlock;
    private final String inferenceId;
    private final String queryText;
    private final int batchSize;
    private int remainingPositions;

    RerankOperatorRequestIterator(BytesRefBlock inputBlock, String inferenceId, String queryText, int batchSize) {
        this.inputBlock = inputBlock;
        this.inferenceId = inferenceId;
        this.queryText = queryText;
        this.batchSize = batchSize;
        this.remainingPositions = inputBlock.getPositionCount();
    }

    @Override
    public boolean hasNext() {
        return this.remainingPositions > 0;
    }

    @Override
    public InferenceAction.Request next() {
        int pos;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        int maxInputSize = Math.min(this.remainingPositions, this.batchSize);
        ArrayList<String> inputs = new ArrayList<String>(maxInputSize);
        BytesRef scratch = new BytesRef();
        int startIndex = this.inputBlock.getPositionCount() - this.remainingPositions;
        if (this.inputBlock.isNull(startIndex)) {
            --this.remainingPositions;
            return null;
        }
        for (int i = 0; i < maxInputSize && !this.inputBlock.isNull(pos = startIndex + i); ++i) {
            scratch = this.inputBlock.getBytesRef(this.inputBlock.getFirstValueIndex(pos), scratch);
            inputs.add(BytesRefs.toString((Object)scratch));
        }
        this.remainingPositions -= inputs.size();
        return this.inferenceRequest(inputs);
    }

    @Override
    public int estimatedSize() {
        return this.inputBlock.getPositionCount();
    }

    private InferenceAction.Request inferenceRequest(List<String> inputs) {
        return InferenceAction.Request.builder((String)this.inferenceId, (TaskType)TaskType.RERANK).setInput(inputs).setQuery(this.queryText).build();
    }

    public void close() {
        this.inputBlock.allowPassingToDifferentDriver();
        Releasables.close((Releasable)this.inputBlock);
    }
}

