/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.inference.completion;

import java.util.List;
import java.util.NoSuchElementException;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.core.inference.action.InferenceAction;
import org.elasticsearch.xpack.esql.inference.InputTextReader;
import org.elasticsearch.xpack.esql.inference.bulk.BulkInferenceRequestIterator;

class CompletionOperatorRequestIterator
implements BulkInferenceRequestIterator {
    private final InputTextReader textReader;
    private final String inferenceId;
    private final int size;
    private int currentPos = 0;

    CompletionOperatorRequestIterator(BytesRefBlock promptBlock, String inferenceId) {
        this.textReader = new InputTextReader(promptBlock);
        this.size = promptBlock.getPositionCount();
        this.inferenceId = inferenceId;
    }

    @Override
    public boolean hasNext() {
        return this.currentPos < this.size;
    }

    @Override
    public InferenceAction.Request next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.inferenceRequest(this.textReader.readText(this.currentPos++));
    }

    private InferenceAction.Request inferenceRequest(String prompt) {
        if (prompt == null) {
            return null;
        }
        return InferenceAction.Request.builder((String)this.inferenceId, (TaskType)TaskType.COMPLETION).setInput(List.of(prompt)).build();
    }

    @Override
    public int estimatedSize() {
        return this.textReader.estimatedSize();
    }

    public void close() {
        Releasables.close((Releasable)this.textReader);
    }
}

