/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.inference;

import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.esql.expression.function.EsqlFunctionRegistry;
import org.elasticsearch.xpack.esql.inference.InferenceResolver;
import org.elasticsearch.xpack.esql.inference.InferenceSettings;
import org.elasticsearch.xpack.esql.inference.bulk.BulkInferenceRunner;
import org.elasticsearch.xpack.esql.inference.bulk.BulkInferenceRunnerConfig;

public class InferenceService {
    private InferenceSettings inferenceSettings;
    private final InferenceResolver.Factory inferenceResolverFactory;
    private final BulkInferenceRunner.Factory bulkInferenceRunnerFactory;

    public InferenceService(Client client, ClusterService clusterService) {
        this(InferenceResolver.factory(client), BulkInferenceRunner.factory(client), clusterService.getSettings());
        clusterService.getClusterSettings().addSettingsUpdateConsumer(this::updateInferenceSettings, InferenceSettings.getSettings());
    }

    private InferenceService(InferenceResolver.Factory inferenceResolverFactory, BulkInferenceRunner.Factory bulkInferenceRunnerFactory, Settings settings) {
        this.inferenceResolverFactory = inferenceResolverFactory;
        this.bulkInferenceRunnerFactory = bulkInferenceRunnerFactory;
        this.updateInferenceSettings(settings);
    }

    public InferenceSettings inferenceSettings() {
        return this.inferenceSettings;
    }

    private void updateInferenceSettings(Settings settings) {
        this.inferenceSettings = new InferenceSettings(settings);
    }

    public InferenceResolver inferenceResolver(EsqlFunctionRegistry functionRegistry) {
        return this.inferenceResolverFactory.create(functionRegistry);
    }

    public BulkInferenceRunner bulkInferenceRunner() {
        return this.bulkInferenceRunner(BulkInferenceRunnerConfig.DEFAULT);
    }

    public BulkInferenceRunner bulkInferenceRunner(BulkInferenceRunnerConfig bulkInferenceRunnerConfig) {
        return this.bulkInferenceRunnerFactory.create(bulkInferenceRunnerConfig);
    }
}

